#include <sourcemod>
#include <sdkhooks>
#include <tf2_stocks>
#include <clientprefs>
#include <morecolors>
#include <tf2items>
#include <tf2attributes>

#pragma newdecls required
#pragma semicolon 1

public Plugin myinfo =
{
    name = "Market Gardening Arena Plugin",
    author = "SpookyMonster",
    description = "Handles weapon bans, class restriction, damage, basic commands, etc.",
    version = "1.0",
    url = ""
};

// Ban weapon indexes
// Banners use tf_weapon_buff_item
// Shotguns use tf_weapon_shotgun and tf_weapon_shotgun_soldier
int g_iBanWeaponIndexes[] =
{
    127, // Direct Hit
    357, // Half-Zatoichi
    414, // Liberty Launcher
    442, // Righteous Bison
    444, // Mantreads
    447, // Disciplinary Action
    474, // Conscientious Objector
    775, // Escape Plan
    1101, // B.A.S.E Jumper
    1104 // Air Strike
};

char g_sBanWeaponNames[][] =
{
    "Direct Hit",
    "Half-Zatoichi",
    "Liberty Launcher",
    "Righteous Bison",
    "Mantreads",
    "Disciplinary Action",
    "Conscientious Objector",
    "Escape Plan",
    "B.A.S.E Jumper",
    "Air Strike"
};

// Client globals
bool g_bThirdPersonEnabled[MAXPLAYERS + 1];

// Ammo refill
int g_iOffset_ammo;
int g_iOffset_clip;

// Blocked sounds
char g_sDisabledSounds[][] =
{
    "paincriticaldeath",
    "painsevere",
    "painsharp",
    "pl_fallpain",
    "pl_fleshbreak",
};

Cookie g_cookieFov;
Cookie g_cookieKillstreak;

int g_iResetMapTimer = 10800;

public void OnPluginStart()
{
    // Cookies
    g_cookieFov = RegClientCookie("player_fov", "Client's FOV", CookieAccess_Private);
    g_cookieKillstreak = RegClientCookie("player_killstreak", "Client's killstreak", CookieAccess_Private);

    // Commands
    RegConsoleCmd("sm_commands", Command_CommandsInfo);
    RegConsoleCmd("sm_cmds", Command_CommandsInfo);

    // Register commands
    RegConsoleCmd("sm_thirdperson", Command_Thirdperson);
    RegConsoleCmd("sm_tp", Command_Thirdperson);
    RegConsoleCmd("sm_firstperson", Command_Firstperson);
    RegConsoleCmd("sm_fp", Command_Firstperson);
    RegConsoleCmd("sm_fov", Command_Fov);
    RegConsoleCmd("sm_ks", Command_Killstreak);
    RegConsoleCmd("sm_discord", Command_Discord);

    // Hooks
    HookEvent("player_spawn", Event_PlayerSpawn);
    HookEvent("player_death", Event_PlayerDeath);

    HookUserMessage(GetUserMessageId("VoiceSubtitle"), Hook_VoiceSubtitle, true);

    AddTempEntHook("TFBlood", Hook_Effect);
    AddTempEntHook("TFExplosion", Hook_Effect);
    AddTempEntHook("TFParticleEffect", Hook_Effect);

    AddNormalSoundHook(Hook_SoundFilter);

    // Ammo and health regen
    g_iOffset_ammo = FindSendPropInfo("CBasePlayer", "m_iAmmo");
    g_iOffset_clip = FindSendPropInfo("CBaseCombatWeapon", "m_iClip1");

    // Health and ammo regen timer
    CreateTimer(0.1, Timer_RegenHealthAmmo, _, TIMER_REPEAT);

    // Discord advertisement
    CreateTimer(900.0, Timer_AdvertiseDiscord, _, TIMER_REPEAT);

    // Map reset when no one on the server
    CreateTimer(600.0, Timer_ResetMapEmpty, _, TIMER_REPEAT);

    // Map reset
    g_iResetMapTimer = 10800; // 5 hours
    CreateTimer(1.0, Timer_ResetMap, _, TIMER_REPEAT);
}

public Action OnPlayerRunCmd(int client, int& buttons, int& impulse, float vel[3], float angles[3], int& weapon, int& subtype, int& cmdnum, int& tickcount, int& seed, int mouse[2])
{
    // Prevent Cow Mangler alt fire
    if (IsValidClient(client))
    {
        int iActiveWep = GetEntPropEnt(client, Prop_Send, "m_hActiveWeapon");
        if (GetEntProp(iActiveWep, Prop_Send, "m_iItemDefinitionIndex") == 441)
        {
            if (buttons & IN_ATTACK2)
            {
                buttons &= ~IN_ATTACK2;
            }
        }
    }

    return Plugin_Continue;
}

public Action TF2Items_OnGiveNamedItem(int client, char[] classname, int itemDefinitionIndex, Handle& item)
{
    for (int i = 0; i < sizeof(g_iBanWeaponIndexes); i++)
    {
        if (itemDefinitionIndex == g_iBanWeaponIndexes[i])
        {
            CPrintToChat(client, "{yellow}[GFR] {orange}%s {default}is banned!", g_sBanWeaponNames[i]);
            return Plugin_Stop;
        }
    }

    if (StrEqual(classname, "tf_weapon_buff_item"))
    {
        CPrintToChat(client, "{yellow}[GFR] {orange}Banners {default}are banned!");
        return Plugin_Stop;
    }

    if (StrEqual(classname, "tf_weapon_shotgun") || StrEqual(classname, "tf_weapon_shotgun_soldier"))
    {
        CPrintToChat(client, "{yellow}[GFR] {orange}Shotguns {default}are banned!");
        return Plugin_Stop;
    }

    return Plugin_Continue;
}

public void TF2Items_OnGiveNamedItem_Post(int client, char[] classname, int itemDefinitionIndex, int itemLevel, int itemQuality, int weaponIndex)
{
    if(StrEqual(classname, "tf_weapon_shovel") || StrEqual(classname, "saxxy"))
    {
        if (itemDefinitionIndex == 416)
        {
            // This doesn't work
            TF2Attrib_RemoveByName(weaponIndex, "fire rate penalty");
        } else
        {
            TF2Attrib_SetByName(weaponIndex, "mod crit while airborne", 1.0);
        }
    }
}

public Action Timer_RegenHealthAmmo(Handle timer)
{
    for (int i = 1; i <= MaxClients; i++)
    {
        if (IsValidClient(i) && IsPlayerAlive(i))
        {
            if (TF2_GetPlayerClass(i) == TFClass_Soldier)
            {
                // Class Soldier

                // AMMO
                int weapon = GetEntPropEnt(i, Prop_Send, "m_hActiveWeapon");
                if (IsValidEntity(weapon))
                {
                    int iWeaponIndex = GetEntProp(weapon, Prop_Send, "m_iItemDefinitionIndex");
                    int ammotype = GetEntProp(weapon, Prop_Send, "m_iPrimaryAmmoType") * 4;

                    switch (iWeaponIndex)
                    {
                        case 441:
                        {
                            // Cow Mangler
                            SetEntPropFloat(weapon, Prop_Send, "m_flEnergy", 20.0);
                        }
                        case 730:
                        {
                            // Beggar's Bazooka
                            SetEntData(i, ammotype + g_iOffset_ammo, 60, 4, true);
                        }
                        default:
                        {
                            // Other
                            SetEntData(weapon, g_iOffset_clip, 4, 4, true);
                            SetEntData(i, ammotype + g_iOffset_ammo, 60, 4, true);
                        }
                    }
                }
                // HEALTH
                SetEntityHealth(i, 500);
            }
        }
    }
    return Plugin_Continue;
}

public Action Timer_AdvertiseDiscord(Handle timer)
{
    CPrintToChatAll("{yellow}[GFR] {default}Join our {steelblue}Discord{default}: {lightgreen}/discord {default}or {blue}https://discord.gg/9BpySYHac7");
    return Plugin_Continue;
}

public Action Timer_ResetMapEmpty(Handle timer)
{
    if (GetClientCount() < 1)
    {
        g_iResetMapTimer = 10800;

        char sMapName[64];
        GetCurrentMap(sMapName, 64);

        ServerCommand("changelevel %s", sMapName);
    }
    return Plugin_Continue;
}

public Action Timer_ResetMap(Handle timer)
{
    g_iResetMapTimer--;

    if (g_iResetMapTimer == 600)
    {
        CPrintToChatAll("{yellow}[GFR] {orange}Server is restarting in 10 minutes!");
    }

    if (g_iResetMapTimer == 300)
    {
        CPrintToChatAll("{yellow}[GFR] {orange}Server is restarting in 5 minutes!");
    }

    if (g_iResetMapTimer == 60)
    {
        CPrintToChatAll("{yellow}[GFR] {orange}Server is restarting in 1 minute!");
    }

    if (g_iResetMapTimer <= 10 && g_iResetMapTimer >= 0)
    {
        if (g_iResetMapTimer != 1)
        {
            CPrintToChatAll("{yellow}[GFR] {orange}Server is restarting in %d seconds!", g_iResetMapTimer);
        } else
        {
            CPrintToChatAll("{yellow}[GFR] {orange}Server is restarting in 1 second!");
        }
    }

    if (g_iResetMapTimer == 0)
    {
        CPrintToChatAll("{yellow}[GFR] {orange}Server is restarting");

        g_iResetMapTimer = 10800;

        char sMapName[64];
        GetCurrentMap(sMapName, 64);

        ServerCommand("changelevel %s", sMapName);
    }

    return Plugin_Continue;
}

public Action Timer_SetPlayerView(Handle timer, int userid)
{
    int client = GetClientOfUserId(userid);

    if (!IsValidClient(client))
    {
        return Plugin_Continue;
    }

    SetVariantInt(1);
    AcceptEntityInput(client, "SetForcedTauntCam");
    return Plugin_Continue;
}

public Action OnGetMaxHealth(int client, int &maxhealth)
{
    maxhealth = 500;
    return Plugin_Changed;
}

public void OnClientPutInServer(int client)
{
    SDKHook(client, SDKHook_OnTakeDamageAlive, Hook_TakeDamage);
    g_bThirdPersonEnabled[client] = false;
}

public void OnClientDisconnect(int client)
{
    SDKUnhook(client, SDKHook_OnTakeDamageAlive, Hook_TakeDamage);
    g_bThirdPersonEnabled[client] = false;
}

public Action Event_PlayerDeath(Handle hEvent, char[] strEventName, bool bDontBroadcast)
{
    int userid = GetEventInt(hEvent, "userid");
    RequestFrame(RespawnPlayer, userid);
    return Plugin_Handled;
}

public void RespawnPlayer(int userid)
{
    int client = GetClientOfUserId(userid);

    if (!IsValidClient(client))
    {
        return;
    }

    if (IsPlayerAlive(client))
    {
        return;
    }

    int iClientTeam = GetClientTeam(client);

    if (iClientTeam == 2 || iClientTeam == 3)
    {
        TF2_RespawnPlayer(client);
    }
}

public Action Event_PlayerSpawn(Handle hEvent, char[] strEventName, bool bDontBroadcast)
{
    int userid = GetEventInt(hEvent, "userid");
    int client = GetClientOfUserId(userid);

    if (!IsValidClient(client))
    {
        return Plugin_Continue;
    }

    SDKHook(client, SDKHook_GetMaxHealth, OnGetMaxHealth);

    if (AreClientCookiesCached(client))
    {
        char sFovCookie[16];
        GetClientCookie(client, g_cookieFov, sFovCookie, sizeof(sFovCookie));
        int fov = StringToInt(sFovCookie);
        if (10 <= fov && fov <= 170)
        {
            SetEntProp(client, Prop_Send, "m_iFOV", fov);
            SetEntProp(client, Prop_Send, "m_iDefaultFOV", fov);
        }

        char sKillstreakCookie[16];
        GetClientCookie(client, g_cookieKillstreak, sKillstreakCookie, sizeof(sKillstreakCookie));
        int ks = StringToInt(sKillstreakCookie);
        if (0 <= ks && ks <= 100)
        {
            SetEntProp(client, Prop_Send, "m_nStreaks", ks);
        }
    }

    if (g_bThirdPersonEnabled[client])
    {
        CreateTimer(0.2, Timer_SetPlayerView, userid, TIMER_FLAG_NO_MAPCHANGE);
    }

    // Force class to Soldier and ban weapons if team is assigned
    
    int clientTeam = GetClientTeam(client);

    if (clientTeam == 2 || clientTeam == 3) // 2 = RED, 3 = BLU
    {
        if (IsPlayerAlive(client))
        {
            if (TF2_GetPlayerClass(client) != TFClass_Soldier)
            {
                TF2_SetPlayerClass(client, TFClass_Soldier, false, true);
                TF2_RespawnPlayer(client);
                CPrintToChat(client, "{yellow}[GFR] {default}Class is restricted to {lightgreen}Soldier {default}only");
            }
        }
    }
    
    return Plugin_Continue;
}

public Action Command_Fov(int client, int args)
{
    if (!AreClientCookiesCached(client))
    {
        return Plugin_Handled;
    }

    if (args == 0)
    {
        QueryClientConVar(client, "fov_desired", OnFovQueried);
        CPrintToChat(client, "{yellow}[GFR] {default}Your FOV has been reset");
        return Plugin_Handled;
    }

    char sArg[16];
    GetCmdArg(1, sArg, sizeof(sArg));

    int fov = StringToInt(sArg);

    if (fov < 10)
    {
        CPrintToChat(client, "{yellow}[GFR] {default}Minimum FOV is {lightgreen}10");
        return Plugin_Handled;
    }
    if (fov > 170)
    {
        CPrintToChat(client, "{yellow}[GFR] {default}Maximum FOV is {lightgreen}170");
        return Plugin_Handled;
    }

    char sCookie[16];
    IntToString(fov, sCookie, sizeof(sCookie));
    SetClientCookie(client, g_cookieFov, sCookie);

    SetEntProp(client, Prop_Send, "m_iFOV", fov);
    SetEntProp(client, Prop_Send, "m_iDefaultFOV", fov);

    CPrintToChat(client, "{yellow}[GFR] {default}Your FOV has been set to {lightgreen}%d {default}on this server", fov);

    return Plugin_Handled;
}

public Action Command_Killstreak(int client, int args)
{
    if (!AreClientCookiesCached(client))
    {
        return Plugin_Handled;
    }

    if (args == 0)
    {
        SetEntProp(client, Prop_Send, "m_nStreaks", 0);
        SetClientCookie(client, g_cookieKillstreak, "0");
        CPrintToChat(client, "{yellow}[GFR] {default}Your killstreak has been reset");
        return Plugin_Handled;
    }

    char sArg[16];
    GetCmdArg(1, sArg, sizeof(sArg));

    int ks = StringToInt(sArg);

    if (ks < 0)
    {
        ks = 0;
        CPrintToChat(client, "{yellow}[GFR] {default}Can't set killstreak negative");
    } else if (ks > 100)
    {
        ks = 100;
        CPrintToChat(client, "{yellow}[GFR] {default}Maximum killstreak is {lightgreen}100");
    } else
    {
        CPrintToChat(client, "{yellow}[GFR] {default}Your killstreak has been set to {lightgreen}%d {default}on this server", ks);
    }

    SetEntProp(client, Prop_Send, "m_nStreaks", ks);

    char sCookie[16];
    IntToString(ks, sCookie, sizeof(sCookie));
    SetClientCookie(client, g_cookieKillstreak, sCookie);

    return Plugin_Handled;
}

public Action Command_Thirdperson(int client, int args)
{
    SetVariantInt(1);
    AcceptEntityInput(client, "SetForcedTauntCam");
    g_bThirdPersonEnabled[client] = true;
    return Plugin_Handled;
}

public Action Command_Firstperson(int client, int args)
{
    SetVariantInt(0);
    AcceptEntityInput(client, "SetForcedTauntCam");
    g_bThirdPersonEnabled[client] = false;
    return Plugin_Handled;
}

public Action Command_Discord(int client, int args)
{
    ShowMOTDPanel(client, "GFR Discord", "https://discord.gg/9BpySYHac7", MOTDPANEL_TYPE_URL);
    return Plugin_Handled;
}

public Action Command_CommandsInfo(int client, int args)
{
    Menu menu = new Menu(Menu_CommandsInfo);
    menu.SetTitle("Commands:");

    menu.AddItem("top", "/leaderboard, /top");
    menu.AddItem("rank", "/rank <name>");
    menu.AddItem("tp", "/thirdperson, /tp");
    menu.AddItem("fp", "/firstperson, /fp");
    menu.AddItem("fov", "/fov <number>", ITEMDRAW_DISABLED);
    menu.AddItem("ks", "/ks <number>", ITEMDRAW_DISABLED);
    menu.AddItem("duel", "/duel <name>", ITEMDRAW_DISABLED);
    menu.AddItem("exit", "/resign, /leave, /exit, /r", ITEMDRAW_DISABLED);
    menu.AddItem("discord", "/discord");

    menu.Display(client, 30);

    return Plugin_Handled;
}

public void OnFovQueried(QueryCookie cookie, int client, ConVarQueryResult result, const char[] cvarName, const char[] cvarValue, any value)
{
    if (result != ConVarQuery_Okay)
    {
        return;
    }

    int fov = StringToInt(cvarValue);

    SetClientCookie(client, g_cookieFov, "");
    SetEntProp(client, Prop_Send, "m_iFOV", fov);
    SetEntProp(client, Prop_Send, "m_iDefaultFOV", fov);
}

public Action Hook_VoiceSubtitle(UserMsg msg_id, BfRead msg, const int[] players, int playersNum, bool reliable, bool init)
{
    // Intercept voice command subtitles
    return Plugin_Handled;
}

public Action Hook_Effect(const char[] te_name, const int[] players, int numClients, float delay)
{
    // Intercept effects
    return Plugin_Stop;
}

public Action Hook_SoundFilter(int clients[64], int& numClients, char sSample[PLATFORM_MAX_PATH], int& entity, int& channel, float& volume, int& level, int& pitch, int& flags)
{
    for (int i = 0; i < sizeof(g_sDisabledSounds); i++)
    {
        if (StrContains(sSample, g_sDisabledSounds[i], false) != -1)
        {
            return Plugin_Stop;
        }
    }
    return Plugin_Continue;
}

public Action Hook_TakeDamage(int victim, int& attacker, int& inflictor, float& damage, int& damagetype)
{
    if (damagetype & DMG_FALL)
    {
        return Plugin_Handled;
    }

    if (damagetype & DMG_CRIT)
    {
        damage = 500.0;
        return Plugin_Changed;
    }

    return Plugin_Continue;
}

public int Menu_CommandsInfo(Menu menu, MenuAction action, int param1, int param2)
{
    switch (action)
    {
        case MenuAction_Select:
        {
            char item[8];
            menu.GetItem(param2, item, sizeof(item));

            if (StrEqual(item, "top"))
            {
                FakeClientCommand(param1, "say /top");
            } else if (StrEqual(item, "rank"))
            {
                FakeClientCommand(param1, "say /rank");
            } else if (StrEqual(item, "tp"))
            {
                FakeClientCommand(param1, "say /tp");
            } else if (StrEqual(item, "fp"))
            {
                FakeClientCommand(param1, "say /fp");
            } else if (StrEqual(item, "discord"))
            {
                FakeClientCommand(param1, "say /discord");
            }
        }
        case MenuAction_End:
        {
            delete menu;
        }
    }
    return 0;
}

bool IsValidClient(int client)
{
    if (0 < client && client <= MaxClients)
    {
        if (IsClientInGame(client))
        {
            return true;
        }
    }
    return false;
}