#version 330

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normal_data;
layout(location = 2) in vec2 uv;


uniform mat4 model_matrix;
uniform mat4 view_matrix;
uniform mat4 mv_matrix;
uniform mat4 projection_matrix;

out vec4 gl_Position;
out vec4 frag_position;
out vec3 frag_normal;
out vec2 frag_uv;

void main()
{
	gl_Position = projection_matrix * view_matrix * model_matrix * vec4(position, 1.0f);

	frag_position = model_matrix * vec4(position, 1.0f);
	frag_normal = normal_data;
	frag_uv = uv;
}

