#version 330

in vec4 frag_normal;
in vec4 frag_position;


uniform vec3 object_color;
uniform vec3 light_position;


out vec4 final_color;


void main()
{

	vec3 normal = normalize(frag_normal.xyz);
	vec3 light_direction = normalize(light_position - frag_position.xyz);

	float diffuse_intensity = max(dot(normal, light_direction), 0.0f);
	vec3 diffuse = (diffuse_intensity * vec3(0.8f, 0.8f, 0.8f));

	final_color = vec4((vec3(0.3f, 0.3f, 0.5f) + diffuse) * object_color, 1.0f);

}
