#ifndef VEC3_H
#define VEC3_H

struct vec3 {
	float x;
	float y;
	float z;
};

struct vec3 vec3(float, float, float);
struct vec3 vec3_cross(struct vec3 a, struct vec3 b);
struct vec3 vec3_normalize(struct vec3 vector);
float vec3_dot(struct vec3 a, struct vec3 b);
struct vec3 vec3_subtract(struct vec3 a, struct vec3 b);
struct vec3 vec3_add(struct vec3 a, struct vec3 b);
struct vec3 vec3_multiply_float(struct vec3 vector, float value);
struct vec3 vec3_invert(struct vec3 vector);
struct vec3 vec3_rgb_clamp(struct vec3 vector);
struct vec3 vec3_hex_to_rgb(int);
struct vec3 vec3_zero(void);
float vec3_distance(struct vec3, struct vec3);
float vec3_length(struct vec3);
struct vec3 vec3_multiply(struct vec3, struct vec3);
struct vec3 vec3_divide(struct vec3 v1, struct vec3 v2);
struct vec3 vec3_divide_float(struct vec3, float);
void vec3_set_length(struct vec3 *, float);
float vec3_len2(struct vec3);
void vec3_from_string(struct vec3 *, char *);

#endif
