#include <math.h>
#include <stdio.h>
#include "vec3.h"

struct vec3 vec3(float x, float y, float z)
{
	struct vec3 v;
	v.x = x;
	v.y = y;
	v.z = z;

	return v;
}

struct vec3 vec3_cross(struct vec3 a, struct vec3 b)
{
	//reminder: double check your functions, or you will spend another two days searching why your code doesn't work
	//when you just put an x instead of a z and didn't verify what you typed
	struct vec3 product;
	product.x = a.y * b.z - a.z * b.y;
	product.y = a.z * b.x - a.x * b.z;
	product.z = a.x * b.y - a.y * b.x;

	return product;
}

struct vec3 vec3_normalize(struct vec3 vector)
{
	struct vec3 norm;
	float width = sqrt(vector.x * vector.x + vector.y * vector.y + vector.z * vector.z);
	norm.x = vector.x / width;
	norm.y = vector.y / width;
	norm.z = vector.z / width;

	return norm;
}

float vec3_dot(struct vec3 a, struct vec3 b)
{
	return a.x * b.x + a.y * b.y + a.z * b.z;
}

struct vec3 vec3_subtract(struct vec3 a, struct vec3 b)
{
	struct vec3 result;
	result.x = a.x - b.x;
	result.y = a.y - b.y;
	result.z = a.z - b.z;

	return result;
}

struct vec3 vec3_add(struct vec3 a, struct vec3 b)
{
	struct vec3 result;
	result.x = a.x + b.x;
	result.y = a.y + b.y;
	result.z = a.z + b.z;

	return result;
}

struct vec3 vec3_multiply(struct vec3 v1, struct vec3 v2)
{
	struct vec3 v3;
	v3.x = v1.x * v2.x;
	v3.y = v1.y * v2.y;
	v3.z = v1.z * v2.z;

	return v3;
}

struct vec3 vec3_divide(struct vec3 v1, struct vec3 v2)
{
	struct vec3 v3;
	v3.x = v1.x / v2.x;
	v3.y = v1.y / v2.y;
	v3.z = v1.z / v2.z;

	return v3;
}

struct vec3 vec3_multiply_float(struct vec3 vector, float value)
{
	vector.x = vector.x * value;
	vector.y = vector.y * value;
	vector.z = vector.z * value;
	
	return vector;
}


struct vec3 vec3_invert(struct vec3 vector)
{
	vector.x = vector.x * -1.0f;
	vector.y = vector.y * -1.0f;
	vector.z = vector.z * -1.0f;

	return vector;
}

struct vec3 vec3_rgb_clamp(struct vec3 vector)
{
	vector.x = vector.x / 255;
	vector.y = vector.y / 255;
	vector.z = vector.z / 255;
	
	return vector;
}

//https://stackoverflow.com/a/3723973
//note: this won't work on Big-endian machines, right?
struct vec3 vec3_hex_to_rgb(int hex)
{
	struct vec3 color;
	color.x = ((hex >> 16) & 0xFF) / 255.0f;
	color.y = ((hex >> 8) & 0xFF) / 255.0f;
	color.z = ((hex) & 0xFF) / 255.0f;
	return color;
}

struct vec3 vec3_zero(void)
{
	struct vec3 vector;
	vector.x = 0.0f;
	vector.y = 0.0f;
	vector.z = 0.0f;

	return vector;
}

float vec3_distance(struct vec3 v1, struct vec3 v2)
{
	float distance = sqrt(pow(v2.x - v1.x, 2) + pow(v2.y - v1.y, 2) + pow(v2.z - v1.z, 2) * 1.0);
	return distance;
}

float vec3_length(struct vec3 v)
{
	float length = sqrt(pow(v.x, 2) + pow(v.y, 2) + pow(v.z ,2));
	return length;
}

struct vec3 vec3_divide_float(struct vec3 v, float f)
{
	struct vec3 n;
	n.x = v.x / f;
	n.y = v.y / f;
	n.z = v.z / f;

	return n;
}

void vec3_set_length(struct vec3 *v, float l)
{
	*v = vec3_divide_float(*v, vec3_length(*v));
	*v = vec3_multiply_float(*v, l);
}

float vec3_len2(struct vec3 v)
{
	return v.x * v.x + v.y * v.y + v.z * v.z;
}


void vec3_from_string(struct vec3 *v, char *t)
{
	float x = 0, y = 0, z = 0;
	if (sscanf(t, "%f %f %f", &x, &y, &z) == 3) {
		v->x = x;
		v->y = y;
		v->z = z;
	}
}
