#include <math.h>

#include "quat.h"

//https://www.opengl-tutorial.org/assets/faq_quaternions/index.html#Q56
struct quat quat(float angle, struct vec3 v)
{
	v = vec3_normalize(v);

	float sin_angle = sin(angle / 2);
	float cos_angle = cos(angle / 2);

	struct quat q;
	q.x = v.x * sin_angle;
	q.y = v.y * sin_angle;
	q.z = v.z * sin_angle;
	q.w = cos_angle;
	return q;
}
