#ifndef MAT4_H
#define MAT4_H

#include "vec3.h"
#include "quat.h"


float * mat4_identity(void);
float * mat4_projection(float fov, float z_near, float z_far, float aspect_ratio);
void mat4_look_at(float *matrix, struct vec3 camera_location, struct vec3 center, struct vec3 up);
void mat4_translate(float *matrix, struct vec3 direction);
void mat4_position(float *, struct vec3);
void mat4_multiply(float *matrix_a, float *matrix_b, float *matrix_out);
void mat4_multiply_vec3(struct vec3 *, float *);
void mat4_scale(float *m, struct vec3 v);
void mat4_from_quat(float *, struct quat);


#endif
