#include <stdarg.h>
#include <string.h>

#include "io.h"
#include "states.h"
#include "../ui/stats.h"
#include "../net/clt.h"
#include "../net/nconf.h"


static char s[IO_MAX_BYTES] = {0};

//print a message onto the screen and to stdin.
void prnt(char *f, ...)
{
	va_list ap;
	va_start(ap, f);
	
	vsnprintf(s, IO_MAX_BYTES-1, f, ap); //-1 to always leave s terminated by 0
	fprintf(stdin, "%s", s);

	va_end(ap);
}

//print an error message onto the screen and to stderr.
void prnte(char *f, ...)
{
	va_list ap;
	va_start(ap, f);
	
	vsnprintf(s, IO_MAX_BYTES-1, f, ap);
	fprintf(stderr, "%s", s);
	hud_new_chat(s, MSG_ERR);

	va_end(ap);
}

//print a message on the screen, and give it to the client function to send it to
//other players if in an online game.
void prntm(char *f, ...)
{
	va_list ap;
	va_start(ap, f);

	vsnprintf(s, IO_MAX_BYTES-1, f, ap);

	char t[IO_MAX_BYTES + CLT_MAX_NAME_LENGTH];
	strcpy(t, clt_get_name());
	strcat(t, ": ");
	strcat(t, s);

	hud_new_chat(t, MSG);

	if (extern_is_client || extern_is_server)
		clt_send_message(t);

	va_end(ap);
}

//print a message on the screen, and to stdin.
void prnti(char *f, ...)
{
	va_list ap;
	va_start(ap, f);
	
	vsnprintf(s, IO_MAX_BYTES-1, f, ap);
	fprintf(stdin, "%s", s);
	hud_new_chat(s, MSG_INF);

	va_end(ap);
}
