#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "csv.h"

//!!! this array will be overwritten each time a new call to csv_parse is made !!!
char file_string[CSV_MAX_LINE_LENGTH];



//Parses a given csv file searching for the line containing the given keyword in
//the given column name. Returns a pointer to the line's content if the keyword was found,
//NULL otherwise. Only the first occurence of the keyword will be matched.
char * csv_parse(char *filepath, char *column, char *keyword)
{
	FILE *csv;
	char search_pattern[CSV_MAX_LINE_LENGTH];

	//open the file
	if ((csv = fopen(filepath, "rb")) == NULL)
	{
		fprintf(stderr, "Error: the csv file doesn't exist or could not be opened\n");
		return NULL;
	}

	//get the first line
	fgets(file_string, sizeof(file_string), csv);
	//return a pointer of the column name in the string
	char *loc = strstr(file_string, column);
	if (loc == NULL)
	{
		fprintf(stderr, "Error: the column name doesn't exist\n");
		return NULL;
	}
	//get the location of the column name in the string, by subtracting the main string pointer to the
	//substring pointer
	int sub_string_location = loc - file_string;
	//printf("#### %d\n", sub_string_location);

	//build the search pattern based on the number of ';' between the start
	//of the string and the start of the column name
	int index = 0;
	for (int i = 0; i < sub_string_location; i++)
	{
		if (file_string[i] == ';')
		{
			search_pattern[index++] = '%';
			search_pattern[index++] = '*';
			search_pattern[index++] = '[';
			search_pattern[index++] = '^';
			search_pattern[index++] = ';';
			search_pattern[index++] = ']';
			search_pattern[index++] = ';';
		}
	}
	//add the last match pattern and the null terminator to the search pattern
	search_pattern[index++] = '%';
	search_pattern[index++] = '[';
	search_pattern[index++] = '^';
	search_pattern[index++] = '\n';
	search_pattern[index++] = ';';
	search_pattern[index++] = ']';
	search_pattern[index] = '\0';

	//printf("Search pattern : %s\n", search_pattern);

	char match[CSV_MAX_ENTRY_LENGTH];
	while (fgets(file_string, sizeof(file_string), csv) != NULL)
	{
		sscanf(file_string, search_pattern, match);

		//I have to do smth weird here, it seems like there is a character
		//that's not a newline nor a null terminator appended to the match if
		//it's located at the end of a line in the csv. Thus, strcmp thinks
		//they aren't the same and always fails. I just replace this mystery
		//character here with a terminator if the before last character
		//differs from the one in the keyword. I believe it "shouldn't" cause any
		//trouble. Only time will tell.

		//!!So that means that the csv parser won't work on values that are only one
		//unit long, and it will be unreliable with numbers. This is a FIXME.
		//Edit: apparently it kinda works regardless??
		//Edit2: IT'S THE CARRIAGE RETURN CHARACTER! But there shouldn't be any at the
		//end of lines in unix, no??

		int size = strlen(match);
		if (match[size - 1] != keyword[size - 1])
		{
			match[size - 1] = '\0';
		}

		//continue if the strings aren't the same
		if (strcmp(match, keyword) != 0)
		{
			continue;
		}
		//printf("Found match: %s\nIn string: %s\n", match, file_string);
		fclose(csv);
		return file_string;
	}
	fprintf(stderr, "Error: no match was found\n");
	fclose(csv);
	return NULL;
}
