#include "cfg.h"

static char line[CFG_MAX_LINE_LENGTH] = {0};

static int get_key(char *, char *);
static int get_val(char *, char *);

//read one line of the given file and write the keypair
//in the given char pointers key and value.
//return 0 if everything went well.
//return 1 if the line shouldn't be used (this might mean that the line is
//commented with "#" or that a keypair wasn't found).
//return EOF on end of file.
int cfg_read(FILE *file, char *key, char *value)
{
	//heads-up: in glibc, EOF == -1.
	
	char *rv = fgets(line, CFG_MAX_LINE_LENGTH, file);

	if (rv == NULL) //end of file
		return EOF;
	
	if (line[0] == '#') //line is a comment
		return 1;

	//get the keypair, and check if they can be used or not
	if (get_key(line, key) == 1 || get_val(line, value) == 1)
		return 1;

	return 0;
}

//fill "val" with the value found from "line".
//return 0 when no errors, 1 when an error occured
//and "val" should NOT be used.
static int get_val(char *line, char *val)
{
	char *tmp_line = line;

	//get the last "=" in the string
	int eq_index = 0;
	for (int i = 0; tmp_line[i] != '\0'; i++) {
		if (tmp_line[i] == '=')
			eq_index = i;
	}
	//offset the line by the index of the last "=" +1 to get past it
	tmp_line += eq_index+1;

	int index = 0;
	for (int i = 0; i < CFG_MAX_VALUE_LENGTH; i++) {
		if (tmp_line[i] == '\n' || tmp_line[i] == '#') {

			//if we get here, it means it's the end of the value
			val[index] = '\0';
			return index > 0 ? 0 : 1;
		}
		val[index++] = tmp_line[i];
	}
	return 1; //we should not arrive here
}

//fill "key" with the key found from "line".
//return 0 when no errors, 1 when an error occured and
//"val" should NOT be used.
static int get_key(char *line, char *key)
{
	int index = 0;
	char lc = '\0';
	for (int i = 0; i < CFG_MAX_KEY_LENGTH; i++) {
		switch (line[i]) {
		case '\\':
			if (lc == '\\') {
				//if the char has been escaped, write it in the key.
				key[index++] = line[i];
				lc = '\0';
				continue;
			}
			break;
		case '#':
		case '=': //an equal sign marks the end of a key.
			if (lc == '\\') {
				//if the char has been escaped, write it in the key.
				key[index++] = line[i];
				lc = '\0';
				continue;
			}
			//if we get here, it means it's the end of the key
			key[index] = '\0';
			return index > 0 ? 0 : 1;
		default:
			key[index++] = line[i];
		}
		lc = line[i];
	}
	return 1; //we should not arrive here
}
