#ifndef UI_H
#define UI_H

//this was really tricky to put all the #include at the right
//place. I don't know if the way I did it here is okay, I'll
//see if I run into issues down the road.


#include "../utils/vec3.h"
#include "../utils/vec2.h"
#include "../loader/prop.h"

#define UI_FILE "assets/ui.txt"
#define UI_MAX_PANELS 25

#define UI_DEFAULT_MARKER "@main"
#define UI_MAP_MARKER "@maps"

#define UI_MAX_MARKER_LENGTH 10


//--enums declaration--

enum anchor {
	TOP_LEFT,
	TOP_MIDDLE,
	TOP_RIGHT,
	MIDDLE_LEFT,
	MIDDLE_MIDDLE,
	MIDDLE_RIGHT,
	BOTTOM_LEFT,
	BOTTOM_MIDDLE,
	BOTTOM_RIGHT
};

enum ui_component {
	BUTTON,
	SCROLLBAR
};

enum action {
	LOAD_MAP,
	UI_DISPLAY,
	NO_ACTION
};

enum panel_type {
	MAIN_MENU,
	MAP_LIST
};

//--inclusion of other ui components--

#include "button.h"
#include "text.h"


//to move or to let here?
struct panel {
	struct button **buttons;
	unsigned int button_count;
};


int ui_initialize(void);
int ui_display(char *);
char **ui_get_markers(void);
void ui_anchor_from_string(enum anchor *, char *);
void ui_action_from_string(enum action *, char *, char *);
int ui_panel_allocate(struct panel **);
void ui_set_active_panel(struct panel *);
struct panel *ui_get_active_panel(void);


void ui_update(void);


#endif
