#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "ui.h"
#include "../utils/conf.h"
#include "../loader/ui_loader.h"
#include "stats.h"



FILE *ui_file;
struct panel **panels;
char **panel_markers;

struct panel *active_panel;

int ui_initialize(void)
{
	panels = malloc(sizeof(struct panel *) * UI_MAX_PANELS);
	panel_markers = malloc(sizeof(char *) * UI_MAX_PANELS);

	char *temp = malloc(sizeof(char) * 10);
	char *temp2 = UI_DEFAULT_MARKER;
	memcpy(temp, temp2, sizeof(char) * UI_MAX_MARKER_LENGTH);
	panel_markers[MAIN_MENU] = temp;

	struct panel *current_panel = malloc(sizeof(struct panel));
	current_panel->buttons = malloc(sizeof(struct button*) * 25);
	current_panel->button_count = 0;
	enum panel_type current_panel_type = MAIN_MENU;
	ui_loader_load_ui(current_panel_type, current_panel);
	ui_set_active_panel(current_panel);

	ui_file = fopen(UI_FILE, "rb");
	//ui_display(UI_DEFAULT_MARKER);
	ui_stats_load();
	return 0;
}

char **ui_get_markers(void)
{
	return panel_markers;
}

int ui_display(char *marker)
{
	if (conf_goto_marker(ui_file, marker) == 1) {
		fprintf(stderr, "Error: couldn't find the marker\n");
		return -1;
	}
/*
	char screen_anchor_text[128] = {"middle_middle"};
	char self_anchor_text[128] = {"middle_middle"};
	char position_text[128] = {"0 0 0"};
	char text[128] = {"DEF"};
	char action_text[128] = {"NO_ACTION"};
	char value[128] = {"NO_VALUE"};
	int err;
	while ((err = conf_get(ui_file, "screen_anchor anchor position text action",
		screen_anchor_text, self_anchor_text, position_text, text, action_text)) == 0) {

		enum anchor screen_anchor;
		enum anchor self_anchor;
		enum action action;
		struct vec3 position;

		get_anchor(&screen_anchor, screen_anchor_text);
		get_anchor(&self_anchor, self_anchor_text);
		get_vec3(&position, position_text);
		get_action(&action, value, action_text);

		struct button *button = malloc(sizeof(struct button));

		button->position = position;
		button->self_anchor = self_anchor;
		button->screen_anchor = screen_anchor;
		memcpy(button->text, text, sizeof(text));
		memcpy(button->value, value, sizeof(value));
		button->action = action;
		printf("hello\n");

		printf("BUTTON\npos: %f %f %f\nself_anchor: %d\nscreen_anchor: %d\ntext: %s\nvalue: %s\naction: %d\n", button->position.x, button->position.y, button->position.z, button->self_anchor, button->screen_anchor, button->text, button->value, button->action);




	}
*/
	return 0;
}

void ui_anchor_from_string(enum anchor *a, char *text)
{
	if (strcmp(text, "top_left") == 0) { *a = TOP_LEFT; }
	else if (strcmp(text, "top_middle") == 0) { *a = TOP_MIDDLE;}
	else if (strcmp(text, "top_right") == 0) { *a = TOP_RIGHT;}
	else if (strcmp(text, "middle_left") == 0) { *a = MIDDLE_LEFT;}
	else if (strcmp(text, "middle_right") == 0) { *a = MIDDLE_RIGHT;}
	else if (strcmp(text, "bottom_left") == 0) { *a = BOTTOM_LEFT;}
	else if (strcmp(text, "bottom_middle") == 0) { *a = BOTTOM_MIDDLE;}
	else if (strcmp(text, "bottom_right") == 0) { *a = BOTTOM_RIGHT;}
	else { *a = MIDDLE_MIDDLE;}
}

/*void get_vec3(struct vec3 *v, char *t)
{
	float x, y, z;
	if (sscanf(t, "%f %f %f", &x, &y, &z) == 3) {
		v->x = x;
		v->y = y;
		v->z = z;
	}
}*/

void ui_action_from_string(enum action *a, char *v, char *t)
{
	char key[128];
	char value[128];

	int match_count;
	if ((match_count = sscanf(t, "%s %s", key, value)) == 0) {
		return;
	}

	if (strcmp(key, "ui_maps") == 0) { *a = UI_DISPLAY; }
	else if (strcmp(key, "load_map") == 0) { *a = LOAD_MAP; }
	else { *a = NO_ACTION; }


	if (match_count == 1)
		return;

	memcpy(v, value, sizeof(value));
}

int ui_panel_allocate(struct panel **panel)
{
	//todo
	return 0;
}

void ui_set_active_panel(struct panel *p)
{
	active_panel = p;
}

struct panel *ui_get_active_panel(void)
{
	return active_panel;
}

void ui_update(void)
{
	ui_stats_update();
}
