/*
 * text.* handles the creation, updating and deletion of text strings.
 */

#ifndef TEXT_H
#define TEXT_H

#include "../loader/model.h"
#include "../loader/shprogram.h"
#include "../loader/texture.h"
#include "../utils/vec3.h"
#include "../utils/mat4.h"

#define TEXT_MAX_LETTERS 256
#define TEXT_MAX_STRINGS 64


struct letter_info {
	char letter;
	unsigned int vbo_index;
};

//struct holding the necessary info to render a string with a bitmap font
struct string_info {
	int used;
	struct vec3 position;
	struct vec3 color;

	int letters[TEXT_MAX_LETTERS];
	unsigned int letter_count;
	float letter_width;
	float letter_height;
	unsigned int vao_handle;
	unsigned int vbo_handle;
	struct shp_info *shprogram;
	struct texture_info *texture;
	float *model_matrix;
};


int text_initialize(void);
int text_new(struct vec3, struct vec3, struct vec3, char *);
void text_delete(int);
void text_update(int, char *);
struct string_info * text_get_pointer(void);
void text_append_char(int, char);
void text_remove_chars(int, int);
void text_empty(int);
void text_reset_pos(int, struct vec3);
void text_move(int, struct vec3);
void text_color(int, struct vec3);

#endif
