#include <stdio.h>
#include <string.h>

#include "stats.h"
#include "text.h"
#include "../utils/states.h"
#include "../utils/vec3.h"
#include "../game/player.h"
#include "../game/keyboard.h"
#include "../net/nconf.h"

#define HUD_MAX_CHAT_MESSAGES 10
#define HUD_MAX_LOG_MESSAGES 10

static int fps = -1;
static char fps_text[10] = {"fps: ###"};
static int hp = -1;
static char hp_text[7] = {"HP: ###"};
static int chat[HUD_MAX_CHAT_MESSAGES] = {-1};
//static int team_hud[MAX_TEAMS] = {-1};
static int cmd_error = -1;
//static int srv_msg = -1;

static struct vec3 chat_pos = {-0.99, -0.91, 0};
//static struct vec3 team_hud_pos = {-0.99, 0, 0};
float msg_height = 0.06;

//loads all of the needed text to create the HUD.
void ui_stats_load(void)
{
	fps = text_new(vec3(0.74,0.96,0), vec3(255,255,255), vec3(5,9,5), fps_text);
	hp = text_new(vec3(-0.15,-0.94,0), vec3(255,255,255), vec3(10,18,10), hp_text);
	keyboard_set_output(
		    text_new(vec3(-0.99,-0.97,0), vec3(255,255,255), vec3(3,6.5,3), ""));
	cmd_error = text_new(vec3(-0.99,-0.97,0), vec3(255,0  ,0  ), vec3(3,6.5,3), "");
	//srv_msg = text_new(vec3(-0.2,0.9,0), vec3(255,255,0), vec3(3,6,0), "player 1 is on a spree!");
	
	float yoffset = chat_pos.y;
	for (int i = 0; i < HUD_MAX_CHAT_MESSAGES; i++) {
		chat[i] = text_new(vec3(chat_pos.x, yoffset, chat_pos.z), vec3(255,255,255), vec3(3,6.5,3), "");
		yoffset += msg_height;
	}
	/*yoffset = team_hud_pos.y;
	for (int i = 0; i < MAX_TEAMS; i++) {
		char s[11];
		sprintf(s, "team %d: 0", i+1);
		team_hud[i] = text_new(vec3(team_hud_pos.x, yoffset, team_hud_pos.z), vec3(255,255,255), vec3(2.8,4.8,0), s);
		yoffset -= msg_height;
	}*/
}

//update hud components that need to be updated each frame.
void ui_stats_update(void)
{
	char n[5] = {0};
	sprintf(n, "%d", extern_fps);
	memcpy(&fps_text[5], n, 5);
	text_update(fps, fps_text);

	//this is run each frame. for health, this seems a bit
	//unnecessary as the value won't change each frame... TODO: move this
	char h[3] = {0};
	sprintf(h, "%d", player_get_hp());
	memcpy(&hp_text[4], h, 3);
	text_update(hp, hp_text);
}

//put a new message into the chat.
void hud_new_chat(char *msg, int type)
{
	//if the new msg is empty, don't do anything
	//if (msg[0] == '\0') { return; }//commented because hud_clear_chat_does exactly this.

	//move all the messages one line up, oldest string comes back to the bottom and gets
	//assigned new text

	//save the last msg
	int tmp = chat[HUD_MAX_CHAT_MESSAGES-1];

	//loop through all the messages and replace each msg by the one below it,
	//the msg at index 0 gets the saved msg
	for (int i = HUD_MAX_CHAT_MESSAGES-1; i >= 0; i--) {
		if (i > 0) {
			chat[i] = chat[i-1];
			text_move(chat[i], vec3(0, msg_height, 0));
		}
	}

	//relocate the last string at the first position and give it the new msg
	chat[0] = tmp;
	text_reset_pos(chat[0], chat_pos);
	text_update(chat[0], msg);

	//color the text depending on it's type
	struct vec3 rgb = vec3(255,255,255);
	switch(type) {
	case MSG_INF:
		rgb = vec3(66, 226, 255);
		break;
	case MSG_WARN:
		rgb = vec3(255, 175, 66);
		break;
	case MSG_ERR:
		rgb = vec3(255, 66, 73);
		break;
	}
	text_color(chat[0],rgb);
}

//clear the chat.
void hud_clear_chat(void)
{
	for (int i = 0; i < HUD_MAX_CHAT_MESSAGES; i++)
		hud_new_chat("", MSG);
}
