#include <stdio.h>
#include <GL/glew.h>
#include <GL/freeglut.h>
#include "renderer.h"
#include "../loader/model.h"
#include "../utils/vec3.h"
#include "../lists/proplist.h"
#include "../ui/ui.h"
#include "../ui/text.h"
#include "../ent/proj.h"

//static struct model *map_skybox;
static struct prop_info **props_list;
static struct panel *active_panel;
static struct proj **proj_list;
static struct string_info *text_list;

static void render_ui(void);
static void render_projs(void);
static void render_text(void);

//initialize the renderer. shp arrays and models arrays MUST be initialized first.
int renderer_initialize(void)
{
	printf("Initializing the renderer...\n");
	//glClearColor(0.0f, 0.4f, 0.3f, 0.0f); //the color used to clear the window
	
	//----clear color sky------
	struct vec3 sky;
	sky.x = 130.0f;
	sky.y = 228.0f;
	sky.z = 232.0f;
	sky = vec3_normalize(sky);
	glClearColor(sky.x, sky.y, sky.z, 0.0f);
	//-------------------------
	glEnable(GL_DEPTH_TEST);
	glDepthMask(GL_TRUE);
	glDepthFunc(GL_LEQUAL);
	glDepthRange(0.0f, 1.0f);
	glPointSize(5);
	props_list = proplist_get_pointer();
	proj_list = proj_get_ptr();
	text_list = text_get_pointer();
	return 0;
}

int renderer_render(void)
{
	//must be before any drawing by OpenGL
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
	for (int i = 0; i < MAX_PROPS; i++) {
		if (props_list[i] == 0) { continue; }
		if (!props_list[i]->visible) { continue; }

		struct model *model = props_list[i]->model;
		//struct model *coll_model = props_list[i]->coll_model;
		//struct bbox_info *bbox = props_list[i]->bbox2;
		struct shp_info *shp = props_list[i]->shprogram;
		struct texture_info *texture = props_list[i]->texture;

		glBindVertexArray(model->vao_handle);
		glUseProgram(shp->handle);

		if (props_list[i]->texture != NULL)
			glBindTexture(GL_TEXTURE_2D, texture->handle);

		//this is horrible, change the loading of the model and use directly prop->color instead
		if (props_list[i]->color.x != -1.0f)
			glUniform3f(props_list[i]->shprogram->uniform_object_color,
			props_list[i]->color.x,
			props_list[i]->color.y,
			props_list[i]->color.z);
		else if (props_list[i]->color_override == NULL)
			glUniform3f(shp->uniform_object_color, model->color.x, model->color.y, model->color.z);
		else
			glUniform3f(shp->uniform_object_color, props_list[i]->color_override->x, props_list[i]->color_override->y, props_list[i]->color_override->z);


		//to move(?)
		float test[16];
		mat4_multiply(props_list[i]->model_matrix, props_list[i]->rotation_matrix, test);
		glUniformMatrix4fv(shp->uniform_model_matrix, 1, GL_FALSE, test/*props_list[i]->model_matrix*/);

		//divided by 3 because the vertex count represent the number of individual
		//values in the vertex buffer, not the number of vertices (composed of 3
		//values). Is this dumb? yes.
		glDrawArrays(GL_TRIANGLES, 0, model->vertex_count[MODEL_VERTEX_BUFFER] / 3);

		glBindTexture(GL_TEXTURE_2D, 0);
/*
		//render the bounding box
		glBindVertexArray(bbox->vao_handle);
		glUniform3f(shp->uniform_object_color, bbox->color.x, bbox->color.y, bbox->color.z);
		glDrawArrays(GL_LINES, 0, bbox->vertices_count / 3);
*/
/*
		//render the collision model
		glBindVertexArray(coll_model->vao_handle);
		glUniform3f(shp->uniform_object_color, 1.0f, 0.0f, 0.0f);
		glDrawArrays(GL_LINES, 0, coll_model->vertex_count[MODEL_VERTEX_BUFFER] / 3);
*/

		glBindVertexArray(0);

	}
	render_ui();
	render_projs();
	render_text();
	glutSwapBuffers();
	return 0;
}

static void render_ui(void)
{
	struct prop_info *p;
	active_panel = ui_get_active_panel();
	if (active_panel == NULL)
		return; //no ui elements to display

	for (int i = 0; i < active_panel->button_count; i++) {
		p = active_panel->buttons[i]->prop;

		glBindVertexArray(p->model->vao_handle);
		glUseProgram(p->shprogram->handle);

		if (p->texture != NULL)
			glBindTexture(GL_TEXTURE_2D, p->texture->handle);

		if (p->color_override == NULL)
			glUniform3f(p->shprogram->uniform_object_color,
			p->model->color.x,
			p->model->color.y,
			p->model->color.z);
		else
			glUniform3f(p->shprogram->uniform_object_color,
			p->color_override->x,
			p->color_override->y,
			p->color_override->z);


		glUniformMatrix4fv(p->shprogram->uniform_model_matrix, 1, GL_FALSE, p->model_matrix);

		//divided by 3 because the vertex count represent the number of individual
		//values in the vertex buffer, not the number of vertices (composed of 3
		//values). Is this dumb? yes.
		glDrawArrays(GL_TRIANGLES, 0, p->model->vertex_count[MODEL_VERTEX_BUFFER] / 3);

		glBindTexture(GL_TEXTURE_2D, 0);
	}
	glBindVertexArray(0);
}


static void render_projs(void)
{
	struct proj *p;
	for (int i = 0; i < MAX_PROJECTILES; i++) {
		p = proj_list[i];
		if (p == NULL || p == 0) { continue; }
		glBindVertexArray(p->prop->model->vao_handle);
		glUseProgram(p->prop->shprogram->handle);

		glUniform3f(p->prop->shprogram->uniform_object_color,
		p->prop->model->color.x,
		p->prop->model->color.y,
		p->prop->model->color.z);

		glUniformMatrix4fv(p->prop->shprogram->uniform_model_matrix, 1, GL_FALSE, p->model_matrix);
		glDrawArrays(GL_TRIANGLES, 0, p->prop->model->vertex_count[MODEL_VERTEX_BUFFER] / 3);


		/*glBindVertexArray(p->prop->bbox2->vao_handle);
		glUniform3f(p->prop->shprogram->uniform_object_color,
			p->prop->bbox2->color.x,
			p->prop->bbox2->color.y,
			p->prop->bbox2->color.z);
		glDrawArrays(GL_LINES, 0, p->prop->bbox2->vertices_count / 3);*/
	}
	glBindVertexArray(0);
}

static void render_text(void)
{
	//parse the string list in search of strings to display
	for (int i = 0; i < TEXT_MAX_STRINGS; i++) {
		if (text_list[i].used == 0) { continue; }

		//found a string to display
		struct string_info t = text_list[i];

		//prepare the differents parameters to render the string
		glBindVertexArray(t.vao_handle);
		glUseProgram(t.shprogram->handle);
		glBindTexture(GL_TEXTURE_2D, t.texture->handle);
		glUniform3f(t.shprogram->uniform_object_color,
			t.color.x, t.color.y, t.color.z);


		struct vec3 offset = {0, 0, 0};

		//push the matrix uniform in the shader
		glUniformMatrix4fv(t.shprogram->uniform_model_matrix, 1, GL_FALSE, t.model_matrix);

		for (int e = 0; e < t.letter_count; e++) {

			//push the offset uniform in the shader
			glUniform3f(t.shprogram->uniform_offset,
				offset.x, offset.y, offset.z);

			//UPDATE: the "first" parameter isn't related to vertices or floats, but the number of
			//"elements". an element is a pack of data that can contain only vertices, or this +
			//normals + ...
			//this "pack of data" is defined when telling OpenGL what's in the VBO.
			//for text, its 3 elements * 2 (2 triangles) = 6. an element is 1 vec3 (vertex) and
			//1 vec2 (UV for that vertex).

			//draw the the elements at the vbo index given by the current letter
			glDrawArrays(GL_TRIANGLES, t.letters[e], 6);

			//increment the offset after each letter drawn
			offset = vec3_add(offset, vec3(t.letter_width,0,0));
		}

		//cleanup
		glBindTexture(GL_TEXTURE_2D, 0);
		glBindVertexArray(0);
	}
}
