#include <stdio.h>
#include <string.h>

#include "prot.h"

static int get_next_bundle(char *, int);
static int is_bundle_whole(char *, int);

//Most functions here return the size in bytes of the infos they added to the buffer.


int prot_head(struct ndata *d, int pid)
{
	((int*)d->buf)[0] = D_START; //indicates the start of a data packet
	((int*)d->buf)[1] = pid; //who this data belongs to
	d->size += 8;
	return 8;
}

int prot_fill(struct ndata *d, int index, char *data, int size)
{
	char *b = d->buf + index;
	memcpy(b, data, size);
	d->size += size;
	return size; //because that's basically what it added
}

//reinitialise the passed data struct size, will
//maybe do other things in the future
void prot_clear(struct ndata *d)
{
	d->size = 8; //the size of the payload's header
}


//temporary function - to change!
int prot_clt_info(struct ndata *d, int pid, int team)
{
	((int*)d->buf)[2] = D_NEWPLAYER;
	((int*)d->buf)[3] = pid;
	((int*)d->buf)[4] = team;
	((int*)d->buf)[5] = D_END;
	d->size += 16;
	return 16;
}

void prot_quit_notice(struct ndata *d, int pid)
{
	((int*)d->buf)[2] = D_PLAYERQUIT;
	((int*)d->buf)[3] = pid;
	((int*)d->buf)[4] = D_END;
	d->size += 12;
}

//read the payload in the buffer and fill the passed dtypes struct
//with the found data.
int prot_decode(struct ndata *d, struct dtypes *dt)
{
	/*for (int i = 0; i < d->size / sizeof(int); i++) {
		printf("%d ",((int*)d->buf)[i]);
	} printf("\n");*/

	int s = d->size;
	char *b = d->buf;

	int h; //header
	int p; //pid of sender
	int t; //data type

	int i = 0; //index used in dt arrays
	dt->data_n = 0;

	int index;

	//get to the first/next data bundle in the buffer
	while ((index = (get_next_bundle(b, s))) >= 0) {

		b += index; //add the index of the starting bundle to the pointer
		//remove the index (can be seen as the size from the previous bundle) from
		//the buffer size
		s -= index;

		//is this check needed?
		if (s < 0) {printf("Read more than allowed!\n"); break;}

		//check if the bundle is complete (ends with D_END)
		if (!is_bundle_whole(b+sizeof(int), s-sizeof(int))) {
			fprintf(stderr, "Error: bundle incomplete\n");
			b+=sizeof(int); s-=sizeof(int);
			continue;
		}
		dt->data_n++; //increment the bundle count number

		h = ((int*)b)[0];
		p = ((int*)b)[3];
		t = ((int*)b)[2];

		//is this check necessary now?
		if (h != D_START) {
			fprintf(stderr, "Error: broken payload\n");
			continue;
		}

		dt->data_t[i] = t;
		dt->sender[i] = p;


		switch (t) {
		case D_PLAYER:
			dt->position[i][0].x = ((float*)b)[4];
			dt->position[i][0].y = ((float*)b)[5];
			dt->position[i][0].z = ((float*)b)[6];
			dt->q[i][0].x = ((float*)b)[7];
			dt->q[i][0].y = ((float*)b)[8];
			dt->q[i][0].z = ((float*)b)[9];
			dt->q[i][0].w = ((float*)b)[10];
			break;
		case D_NEWPLAYER:
			dt->pid[i][0] = ((int*)b)[3];
			dt->team[i] = ((int*)b)[4];
			break;
		case D_PLAYERQUIT:
			dt->pid[i][0] = ((int*)b)[3];
			break;
		case D_NEWPROJECTILE:
			dt->position[i][0].x = ((float*)b)[4];
			dt->position[i][0].y = ((float*)b)[5];
			dt->position[i][0].z = ((float*)b)[6];
			dt->velocity[i][0].x = ((float*)b)[7];
			dt->velocity[i][0].y = ((float*)b)[8];
			dt->velocity[i][0].z = ((float*)b)[9];
			dt->speed[i] = ((float*)b)[10];
		case D_NEWMESSAGE:; //; or the program won't compile on Windows
			char *m = &b[13];
			for (int i = 0; i < PROT_MAX_STRING_LENGTH; i++) {
				dt->message[i] = m[i];
			}
			break;
		}

		//move past the current D_START (or get_next_bundle() will return the same one) 
		b+=sizeof(int);
		s-=sizeof(int);
		i++; //the second call will fill up the next indexes in dt

		//This check below is mainly for Windows clients. when dragging the window, payloads seem to
		//not get sent (by the OS?) and are sent all at once when the window stops getting dragged.
		//This should normally not cause problems because of PROT_BYTE_LENGTH, but I don't know
		//what data types I could add in the future which could potentially fit tightly in a buffer,
		//making the server process all of them and attempt to store them out of bounds in the dtypes
		//struct.
		if (i == PROT_MAX_BUNDLES) {
			fprintf(stderr, "Error: max number of bundles attained, discarding everything else!");
			break; //could return -1 here, no?
		}
	}
	return 0;
}

//return the index of the next bundle (defined by D_START) in the char array
//return -1 if no bundles were found
static int get_next_bundle(char *buf, int size)
{
	int s = size / sizeof(int);
	for (int i = 0; i < s; i++) {
		if (((int*)buf)[i] == D_START)
			return i * sizeof(int);
	}
	return -1;
}

//return 1 if D_END was found in buf before D_START,
//in the bytes specified by size
static int is_bundle_whole(char *buf, int size)
{
	//What if the bundle's data contain an int equal
	//to D_START or D_END? No code has yet been
	//written to handle this.

	int f = 1;
	int s = size / sizeof(int);

	for (int i = 0; i < s; i++) {
		if (((int*)buf)[i] == D_START)
			f = 0;
		if (((int*)buf)[i] == D_END)
			return f;
	}
	return 0;
}
