/*
 * oplayers.* contains code to access data on the other clients present in the game.
 * This is used by the server and the client, so the code was placed here to be
 * used by both parties.
 */

#ifndef OPLAYERS_H
#define OPLAYERS_H

#include "prot.h"
#include "nconf.h"

struct player_info {
	struct prop_info *prop;
	int socket; //the socket isn't used client-side and is set to -1
	int team; //the team of the player
	int pid; //player's pid (and it's index in the oplayers list)
};

int oplayers_init(void);
struct player_info * oplayers_add(int); //to be used by the SERVER
int oplayers_get_pid_from_socket(int);
int oplayers_get_socket_from_pid(int);
struct player_info * oplayers_get_player_info(int);
int oplayers_remove(int);
int oplayers_add_player(int, int, int); //to be used by the CLIENT
void oplayers_update(struct dtypes *, int);
struct prop_info * oplayers_get_prop_from_pid(int);
int oplayers_get_team_from_pid(int);
void oplayers_clear(void);





#endif
