#include <stdio.h>
#include <string.h>
#include <sys/types.h>

#ifdef _WIN32
#include <winsock2.h>
#include <ws2tcpip.h>
#include "wcompat.h"
#else
#include <sys/socket.h>
#include <netdb.h>
#endif
#include <sys/time.h>
#include <sys/unistd.h>

#include "cltgate.h"
#include "clt.h"
#include "prot.h"
#include "../utils/io.h"



static int fd; //server's socket
static fd_set fds; //"file descriptor set"
static fd_set read_fds;
static struct timeval timeout;
int nbytes;
char buf[PROT_BYTE_LENGTH];
int status;
struct ndata din;

static int new_data(void);


//attempt to connect to a server
int cltgate_connect(char *ip, char *p)
{
//this is required on Windows.
#ifdef _WIN32
	wsock_init();
#endif

	struct addrinfo tcp_hints;
	struct addrinfo *srv_info;
	memset(&tcp_hints, 0, sizeof(tcp_hints)); //don't forget this, or getaddrinfo() can't find the server
	tcp_hints.ai_family = AF_INET;
	tcp_hints.ai_socktype = SOCK_STREAM;

	//the time the server will take to check if the server sent data before giving up.
	timeout.tv_sec = 0;
	timeout.tv_usec = 1000; //1 millisecond, since there's only one file descriptor to check

	int status;
	if ((status = getaddrinfo(ip, p, &tcp_hints, &srv_info)) != 0) {
		fprintf(stderr, "Error: could not get address infos, error code = %d\n", status);
		return -1;
	}

	fd = socket(srv_info->ai_family, srv_info->ai_socktype, srv_info->ai_protocol);
	if (fd < 0) {
		fprintf(stderr, "Error: couldn't get a socket\n");
		return -1;
	}

	if (connect(fd, srv_info->ai_addr, srv_info->ai_addrlen) != 0) {
		fprintf(stderr, "Error: couldn't connect to %s\n", ip);
		return -1;
	}
	//empty the file descriptor lists, add the socket to the main file descriptor list.
	FD_ZERO(&fds);
	FD_ZERO(&read_fds);
	FD_SET(fd, &fds);

	printf("connected to %s\n", ip);

	//TODO: move this somewhere else
	char test[256];

	//get server information
	recv(fd, test, 256, 0);
	printf("your player pid is: %d and team is: %d\n", ((int*)test)[2], ((int*)test)[3]);
	clt_set_pid(((int*)test)[2]);
	clt_set_team(((int*)test)[3]);

	return 0;
}

//listen to the server for any nwe incoming data.
void cltgate_listen(void)
{
	read_fds = fds; //select will remove all non-ready connections from it
	if (select(fd + 1, &read_fds, NULL, NULL, &timeout) == -1) {
		fprintf(stderr, "Error: with select()\n");
		return;
	}
	if (FD_ISSET(fd, &read_fds)) {
		new_data();
	}

}

//send data to the server
void cltgate_send(char *d, int len)
{
	//to error-check! it may not have sent all the data!
	send(fd, d, len, 0);
}

//process new data sent by the server
static int new_data()
{
	if ((din.size = recv(fd, din.buf, PROT_BYTE_LENGTH, 0)) <= 0) {
		if (nbytes == 0) {
			prnte("the connection with the server closed\n");
			close(fd);
			FD_CLR(fd, &fds);
			status = 1;
		} else { //got an error (what does it mean??)
			prnte("Error: received from the server\n");
			status = 2;
		}
		return status;
	}
	//valid data
	clt_take_in(&din);
	return status;
}

void cltgate_close(void)
{
	close(fd);
	FD_CLR(fd, &fds);
}
