/*
 * clt.* contains the logic for the client.
 */

#ifndef CLT_H
#define CLT_H

#include "../utils/vec3.h"
#include "../utils/quat.h"
#include "../ent/proj.h"
#include "prot.h"


int clt_initialise(void);
int clt_connect(char *, char *);
int clt_reconnect(void);
void clt_out_player(struct vec3 *, struct quat *);
void clt_out_rocket(struct proj *);
void clt_send_message(char *);
void clt_take_in(struct ndata *);
int clt_listen(void);
int clt_new_player(void);
void clt_set_pid(int);
int clt_get_pid(void);
void clt_set_team(int);
int clt_get_team(void);
char * clt_get_name(void);
void clt_set_name(char *);




#endif
