#include <stdio.h>
#include <stdlib.h>
#include <string.h>
//#include <netinet/in.h> //not in use rn

#include "../loader/loader.h"
#include "../loader/prop.h"
#include "../lists/proplist.h"
#include "../utils/states.h"
#include "../utils/io.h"
#include "cltgate.h"
#include "clt.h"
#include "prot.h"
#include "oplayers.h"
#include "nconf.h"
#include "../ui/stats.h"

static struct ndata d; //data that will be sent out
static struct dtypes dt;
static int pid = -1; //own player's pid
static int team = -1; //own player's team
static char name[CLT_MAX_NAME_LENGTH+1] = {"player\0"};
char ip[16], port[6];

//initialize certain variables.
int clt_initialise(void)
{
	d.size = 0;
	return 0;
}

//connect the client to a server, given it's ip and port.
int clt_connect(char *n_ip, char *n_port)
{
	strcpy(ip, n_ip);
	strcpy(port, n_port);

	cltgate_connect(ip, port);
	return 0;
}

//reconnect the client to the server. useful if the client
//didn't get the server's information (a bug that can happen).
int clt_reconnect(void)
{
	if (!extern_is_client) {
		prnte("You must be a client to use this command.\n");
		return -1;
	}
	cltgate_close();
	oplayers_clear();
	cltgate_connect(ip, port);
	return 0;
}

//send the player informations to the server/other clients.
//p is the player's position, q is the player's orientation
void clt_out_player(struct vec3 *p, struct quat *q)
{
	prot_head(&d, 48);
	((int*)d.buf)[2] = D_PLAYER;
	((int*)d.buf)[3] = pid;
	((float*)d.buf)[4] = p->x;
	((float*)d.buf)[5] = p->y;
	((float*)d.buf)[6] = p->z;
	((float*)d.buf)[7] = q->x;
	((float*)d.buf)[8] = q->y;
	((float*)d.buf)[9] = q->z;
	((float*)d.buf)[10] = q->w;
	((int*)d.buf)[11] = D_END;

	//should only send what I want, not more
	if (extern_is_client)
		cltgate_send(d.buf, 48);
}

//send a new rocket's information to the server/other clients.
void clt_out_rocket(struct proj *p)
{
	prot_head(&d, 48);
	((int*)d.buf)[2]= D_NEWPROJECTILE;
	((int*)d.buf)[3]= pid;
	((float*)d.buf)[4]= p->position.x;
	((float*)d.buf)[5]= p->position.y;
	((float*)d.buf)[6]= p->position.z;
	((float*)d.buf)[7]= p->velocity.x;
	((float*)d.buf)[8]= p->velocity.y;
	((float*)d.buf)[9]= p->velocity.z;
	((float*)d.buf)[10]= p->speed;
	((int*)d.buf)[11] = D_END;

	if (extern_is_client)
		cltgate_send(d.buf, 48);
}

//send a new chat message to the other players.
void clt_send_message(char *m)
{
	prot_head(&d, 12+PROT_MAX_STRING_LENGTH+4);
	((int*)d.buf)[2] = D_NEWMESSAGE;

	//again: a header is 3 ints, so 12 bytes long.

	//this should *definitely* be error checked!
	int i;
	for (i = 0; m[i] != '\0' || i < PROT_MAX_STRING_LENGTH-4; i++) { //-4 to let some place to /0
		d.buf[13+i] = m[i];
	}
	d.buf[12+i] = '\0'; //terminate the string! important!

	//put D_END after the longest possible string
	((int*)d.buf)[3+PROT_MAX_STRING_LENGTH/4] = D_END;

	if (extern_is_client)
		cltgate_send(d.buf, 12+PROT_MAX_STRING_LENGTH+4);
}

//process incoming data
//for now, doesn't ntohX()
void clt_take_in(struct ndata *din)
{
	prot_decode(din, &dt);

	for (int i = 0; i < dt.data_n; i++) {
		switch (dt.data_t[i]) {
		case D_PLAYER:
			oplayers_update(&dt, i);
			break;
		case D_NEWPLAYER:
			oplayers_add_player(dt.pid[i][0], -1, dt.team[i]);
			//the server's player doesn't receive the notification. to change
			prnti("player %d joined.\n", dt.pid[i][0]);
			break;
		case D_PLAYERQUIT:
			oplayers_remove(dt.pid[i][0]);
			prnti("player %d quit.\n", dt.pid[i][0]);
			break;
		case D_NEWPROJECTILE:
			//I don't know why, but with a lot of players connected, for a while after
			//a new player connects, the rockets he fires have a speed of 0. I harcoded
			//the rocket's speed here until I find the problem.
			proj_load(dt.position[i][0], dt.velocity[i][0], /*dt.speed[0]*/1.2, dt.sender[i], P_OROCKET);
			break;
		case D_NEWMESSAGE:
			//don't call prntm, or you'll create an infinite loop
			hud_new_chat(dt.message, MSG);
			break;
		}
	}
}

//start listening to the network.
int clt_listen()
{
	cltgate_listen();
	return 0;
}

void clt_set_pid(int i)
{
	pid = i;
}

int clt_get_pid(void)
{
	return pid;
}

void clt_set_team(int i)
{
	team = i;
}

int clt_get_team(void)
{
	return team;
}

char * clt_get_name(void)
{
	return name;
}

void clt_set_name(char *new_name)
{
	memcpy(name, new_name, CLT_MAX_NAME_LENGTH);
}
