#include <stdio.h>
#include <string.h>

#include "write.h"
#include "map2.h"
#include "../loader/prop.h"
#include "../lists/proplist.h"
#include "../utils/states.h"
#include "../utils/io.h"

static void write(struct prop_info *, FILE *);

//write the map to a file.
void map_write(void)
{
	if (!extern_is_editing) {
		prnte("You need to be in edit mode (-e) to do that.\n");
		return;
	}

	prnti("saving... \n");
	FILE *f;
	char *path = map_get_path();

	//I had to create a temporary path instead of overwriting the file because on Windows,
	//it for some reason simply didn't write to the file...
	
	//create a temporary path ([map_path].tmp)
	char tmp_path[MAP2_MAX_PATH_LENGTH];
	memcpy(tmp_path, path, MAP2_MAX_PATH_LENGTH);
	strcat(tmp_path, MAP2_WRITE_SUFFIX);

	//create a temporary path for the OLD map
	char tmp_path_old[MAP2_MAX_PATH_LENGTH];
	memcpy(tmp_path_old, path, MAP2_MAX_PATH_LENGTH);
	strcat(tmp_path_old, MAP2_WRITE_SUFFIX_OLD);

	//create a temporary file
	if ((f = fopen(tmp_path, "w+")) == NULL) {
		fprintf(stderr, "Error: could not open the desired file: %s\n", tmp_path);
		return;
	}

	//write the props into the temporary file
	struct prop_info *p;
	for (int i = 0; (p = proplist_get_by_index(i)) != NULL; i++) {
		write(p, f);
	}

	fclose(f);

	//rename the current map file
	//rename the new map with the current map name
	//then delete the old map
	rename(path, tmp_path_old);
	rename(tmp_path, path);
	remove(tmp_path_old);

	prnti("%s\n", path);
}


static void write(struct prop_info *p, FILE *f)
{
	switch(p->type) {
	case T_MAP_PROP:
		fprintf(f, "prop ");
		break;
	case PLAYER:
		fprintf(f, "player ");
		break;
	case SKYBOX:
		fprintf(f, "skybox ");
		break;
	default:
		return;
	}
	fprintf(f, "%s pos %f %f %f rot %f %f %f;\n", p->name, p->position.x, p->position.y, p->position.z, 0.0f, 0.0f, 0.0f);
}
