#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "edit.h"
#include "../lists/proplist.h"
#include "../loader/loader.h"
#include "../game/camera.h"
#include "../game/player.h"
#include "../game/coll.h"
#include "../utils/quat.h"
#include "../utils/etc.h"

enum {
	V_TRANSLATE,
	V_ROTATE,
	X_TRANSLATE,
	X_ROTATE,
	Y_TRANSLATE,
	Y_ROTATE,
	Z_TRANSLATE,
	Z_ROTATE
};

static struct prop_info *selected_prop = NULL;
static struct prop_info *selected_control = NULL;
static int selected_control_index;
static struct coll_info ci;
//static struct quat q;

//those 2 params are used to store the length difference between where the
//user clicked and the position of the controls.
static int click = 1;
static struct vec3 click_diff;

static void snap_to(struct prop_info *);
static void update(void);

//array to contain arrow and wheel controls to move/rotate a prop
struct prop_info *controls[8];

void medit_initialize(void)
{
	int i = 0;
	controls[i++] = proplist_get_by_index(loader_load_asset_new("MEDIT_VIEW_TRANSLATE", vec3_zero(), PROP));
	controls[i++] = proplist_get_by_index(loader_load_asset_new("MEDIT_VIEW_ROTATE", vec3_zero(), PROP));
	controls[i++] = proplist_get_by_index(loader_load_asset_new("MEDIT_X_TRANSLATE", vec3_zero(), PROP));
	controls[i++] = proplist_get_by_index(loader_load_asset_new("MEDIT_X_ROTATE", vec3_zero(), PROP));
	controls[i++] = proplist_get_by_index(loader_load_asset_new("MEDIT_Y_TRANSLATE", vec3_zero(), PROP));
	controls[i++] = proplist_get_by_index(loader_load_asset_new("MEDIT_Y_ROTATE", vec3_zero(), PROP));
	controls[i++] = proplist_get_by_index(loader_load_asset_new("MEDIT_Z_TRANSLATE", vec3_zero(), PROP));
	controls[i++] = proplist_get_by_index(loader_load_asset_new("MEDIT_Z_ROTATE", vec3_zero(), PROP));
}

//select the prop under the cursor.
//for now, knowing the coordinates of x and y isn't necessary as the cursor is always
//in the middle of the screen, bu I'd like to implement some kind of "free mouse" mode, where
//the user could freely move the mouse on the screen to select objects without moving the camera.
void medit_select(int x, int y)
{
	if (medit_drag()) { return; } //if the user touched one of the controls, return.
	ci.t = 1;
	ci.colliding_prop = NULL;
	ci.position = camera_get_position();
	ci.velocity = vec3_multiply_float(camera_get_front(), 1000);

	if (coll_ray_collide_bbox(&ci) && coll_point_collide(&ci)) {
		snap_to(ci.colliding_prop);
		selected_prop = ci.colliding_prop;
	}
}

//position the edit controls to the selected prop.
static void snap_to(struct prop_info *p)
{
	printf("a collision happened with %s\n", p->name);
	for (int i = 0; i < 8; i++)
		prop_reset_pos(controls[i], p->position);
}

//checks if the user touches one of the controls
int medit_drag(void)
{
	if (selected_control != NULL) { update(); return 1; };
	ci.t = 1;
	ci.position = camera_get_position();
	ci.velocity = vec3_multiply_float(camera_get_front(), 1000);

	//check if the ray touches one of the controls (we skip the bbox check
	//as it disregards non existing props, which is the case for the controls)
	for (int i = 0; i < 8; i++)
		ci.coll_props[i] = controls[i];
	ci.coll_props_count = 8;
	if (coll_point_collide(&ci)) {
		selected_control = ci.colliding_prop;
		selected_control_index = ci.colliding_prop_index;
		update();
		return 1;
	}
	return 0;
}

//this is used when the left mouse button is released
void medit_clear_controls(void)
{
	selected_control = NULL;
	click = 1;
}

//move the controls
static void update(void)
{
	struct vec3 cpos = camera_get_position();
	struct vec3 ppos = selected_control->position;
	float pitch = camera_get_pitch();
	float yaw = camera_get_yaw();
	struct vec3 tangent = vec3_zero();

	//get the right angle to calculate the tangent
	//struct vec3 r_angle = vec3(ppos.x, cpos.y, ppos.z);
	//struct vec3 r_angle_dist = vec3_subtract(cpos, r_angle);
	struct vec3 r_angle;
	struct vec3 r_angle_dist;


	//bare with me, this is NOT what I wanted to do	
	switch (selected_control_index) {
	case X_TRANSLATE:
		//invert the yaw when it's below 180
		if (yaw < 180)
			yaw = -yaw;
		cpos.y = ppos.y; //if I don't do this, the controls go away too quicly when the user is higher in y pos!
		r_angle = vec3(cpos.x, ppos.y, ppos.z);
		r_angle_dist = vec3_subtract(cpos, r_angle);
		tangent.x = tanf(degrees_to_radians(yaw+90)) * vec3_length(r_angle_dist);
		tangent.x += cpos.x;
		break;
	case Y_TRANSLATE:
		r_angle = vec3(ppos.x, cpos.y, ppos.z);
		r_angle_dist = vec3_subtract(cpos, r_angle);
		tangent.y = tanf(degrees_to_radians(pitch)) * vec3_length(r_angle_dist);
		tangent.y += cpos.y;
		break;
	case Z_TRANSLATE:
		//invert the yaw when its above 90, but not when it's between 270 and 360
		if (yaw > 90) {
			if (yaw < 360 && yaw > 270) {
			} else {
				yaw = -yaw;
			}
		}
		cpos.y = ppos.y;
		r_angle = vec3(ppos.x, ppos.y, cpos.z);
		r_angle_dist = vec3_subtract(cpos, r_angle);
		tangent.z = tanf(degrees_to_radians(yaw)) * vec3_length(r_angle_dist);
		tangent.z += cpos.z;
		break;
	}

	//save the distance between the click of the user and the position of the
	//control, to avoid the "snapping" that happens when the controls goes at
	//the position indicated by the user at the first click.
	if (click) {
		click_diff = ppos;
		click_diff.x -= tangent.x;
		click_diff.y -= tangent.y;
		click_diff.z -= tangent.z;
		click = 0;
	}

	for (int i = 0; i < 8; i++)
	prop_reset_pos(controls[i], vec3(tangent.x + click_diff.x,
					 tangent.y + click_diff.y,
					 tangent.z + click_diff.z));
	prop_reset_pos(selected_prop, selected_control->position);














/*
	struct vec3 high = vec3(r_angle.x, r_angle.y + dist, r_angle.z);
	struct vec3 prop_to_high = vec3_subtract(high, ppos);



	prop_move(selected_control, vec3(0, prop_to_high.y, 0));
*/
}
