#include <stdio.h>
#include <stdlib.h>
#include "main.h"
#include "renderer/renderer.h"
#include "game/op.h"
#include "game/keyboard.h"
#include "game/camera.h"
#include "game/player.h"
#include "game/mouse.h"
#include "utils/states.h"
#include "net/clt.h"
#include "ent/proj.h"
#include "ui/ui.h"

//My knowledge in C is nonexistent, if you haven't already found out.
//-me, april 2021

int CurrentWidth = 1280,
	CurrentHeight = 720,
	WindowHandle;

unsigned int FrameCount = 0;

//declaration of extern variables
int extern_last_time;
int extern_current_time;
float extern_delta_time;
int extern_window_width;
int extern_window_height;
int extern_is_server = 0;
int extern_is_client = 0;
int extern_is_editing = 0;
int extern_is_cmd = 0;
int extern_fps = 0;
int extern_is_typing = 0;

//glutSwapBuffers() uses it's own GLUT_FPS env var, which I don't know how to change, meaning
//the frames can be lower but not higher than 60. (does it change on a higher refresh rate screen?)
static int fps = 60;

int main(int argc, char* argv[])
{
	Initialize(argc, argv);
	wait_refresh(0);
	glutMainLoop();
}

void Initialize(int argc, char* argv[])
{
	InitWindow(argc, argv);

	//GLenum GlewInitResult = glewInit();
	glewInit();
	//Error handling code should go here, to check if Glew has been correctly
	//initialized.

	Op_testmethod();	
	op_process_var(argc, argv);
}

void wait_refresh(int what/*no idea why I have to provide an int*/)
{
	//if there are slow-downs, this will probably cause problems.
	//it could be great to calculate the time to wait with the delta time.
	//What? when the program renders a lot of object, some are not rendered everytime
	//and flicker! shouldn't this bool take care of this??
	//edit: it was because I was in single-buffered mode all along! muahahaha!
	glutTimerFunc(1000 / fps, wait_refresh, 0);
	glutPostRedisplay();
}


void InitWindow(int argc, char* argv[])
{
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE); //DON'T FORGET THIS TO HAVE DOUBLE BUFFERED MODE
	glutInitWindowSize(CurrentWidth, CurrentHeight);
	WindowHandle = glutCreateWindow("progle");

	//makes the cursor invisible
	glutSetCursor(GLUT_CURSOR_NONE);

	//tell FreeGLUT which functions to call on specific events
	glutReshapeFunc(ResizeWindow);
	glutDisplayFunc(RenderFunction);
	glutCloseFunc(CloseFunction);

	glutKeyboardFunc(keyboard_down);
	glutKeyboardUpFunc(keyboard_up);
	glutSpecialFunc(keyboard_special);

	glutMotionFunc(camera_check_movement); //when a mouse button is down
	glutPassiveMotionFunc(camera_check_movement); //when all mouse buttons are up

	glutMouseFunc(mouse_update);

	glutIgnoreKeyRepeat(1);
}

void ResizeWindow(int Width, int Height)
{
	CurrentWidth = Width;
	CurrentHeight = Height;
	extern_window_width = Width;
	extern_window_height = Height;
	glViewport(0, 0, CurrentWidth, CurrentHeight);
}

void RenderFunction(void)
{
	FrameCount++;

	extern_last_time = extern_current_time;
	extern_current_time = glutGet(GLUT_ELAPSED_TIME);
	extern_delta_time = (float)extern_current_time - extern_last_time;
	extern_fps = 1000 / extern_delta_time;

	proj_update_all();
	keyboard_process();
	mouse_process();
	ui_update();

	if (extern_is_client)
		clt_listen();

	player_update_position();

	renderer_render();
}

void CloseFunction(void)
{
	//Renderer_cleanup();
	fprintf(stdout, "Total frames: %d", FrameCount);
}

