#include <stdio.h>
#include <GL/glew.h>
#include "vbo.h"

//todo: add some error checking

//generate a vertex buffer object
int vbo_create(GLuint *vbo_destination)
{
	glGenBuffers(1, vbo_destination);
	return 0;
}

//TODO: add a -1 return value if the vbo couldn't be filled
int vbo_fill_new(GLuint handle, float *vertices, unsigned int vertices_count, GLenum usage, enum data_type type)
{
	printf("filling vbo %u of %d vertices of type %d\n", handle, vertices_count, type);
	glBindBuffer(GL_ARRAY_BUFFER, handle);
	glBufferData(GL_ARRAY_BUFFER, vertices_count * sizeof(float), vertices, usage);

	switch(type) {
	case VERTICES:
		glEnableVertexAttribArray(0);
		glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 0, (void*) 0);
		break;
	case NORMALS:
		glEnableVertexAttribArray(1);
		glVertexAttribPointer(1, 3, GL_FLOAT, GL_FALSE, 0, (void*) 0);
		break;
	case UVS:
		glEnableVertexAttribArray(2);
		glVertexAttribPointer(2, 2, GL_FLOAT, GL_FALSE, 0, (void*) 0);
		break;
	case VBO_TEXT:
		glEnableVertexAttribArray(0);
		glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 5 * sizeof(float), (void*)0);
		glEnableVertexAttribArray(2);
		glVertexAttribPointer(2, 2, GL_FLOAT, GL_FALSE, 5 * sizeof(float), (void*)(3 * sizeof(float)));
	}

	glBindBuffer(GL_ARRAY_BUFFER, 0);
	return 0;
}

//fill the passed vbo with data. the passed vbo will be bound and unbound.
//GLenum usage is GL_STATIC_DRAW, GL_STREAM_DRAW etc.
//TODO: add a -1 return value if the vbo couldn't be filled
int vbo_fill(GLuint *vbo_location, float *vertices, unsigned int vertices_count, GLenum usage)
{

	//bind the buffer, fill it with variables and tell OpenGL the usage of those variables
	glBindBuffer(GL_ARRAY_BUFFER, *vbo_location);

		
	//glBufferData sends the data to the currently bound buffer.
	//DONT FORGET THAT YOU NEED TO SPECIFY THE *SIZE* OF THE MEMORY
	//NEEDED, NOT THE NUMBER OF VERTICES
	glBufferData(GL_ARRAY_BUFFER, vertices_count * sizeof(float), vertices, usage);



	glEnableVertexAttribArray(0); //aka (location = 0) in the vertex shader
	glEnableVertexAttribArray(1);
	glEnableVertexAttribArray(2);
	//explain to OpenGL (the VAO?) what type of data is in the currently bound buffer
	//info: https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glVertexAttribPointer.xhtml
	//currently, the buffer holds 4 floats of vertex data, and 4 floats of
	//normal data. hence the "stride" parameter isn't 0 (it would be if there
	//was only one type of data in the buffer)
	glVertexAttribPointer(0, 4, GL_FLOAT, GL_FALSE, 10 * sizeof(float), (void*) 0);
	glVertexAttribPointer(1, 4, GL_FLOAT, GL_FALSE, 10 * sizeof(float), (void*) (4 * sizeof(float)));
	glVertexAttribPointer(2, 2, GL_FLOAT, GL_FALSE, 10 * sizeof(float), (void*) (8 * sizeof(float)));

	//unbind the buffer
	glBindBuffer(GL_ARRAY_BUFFER, 0);
	return 0;
}

int vbo_bind(GLuint vbo_handle)
{
	glBindBuffer(GL_ARRAY_BUFFER, vbo_handle);
	return 0;
}

int vbo_unbind(void)
{
	glBindBuffer(GL_ARRAY_BUFFER, 0);
	return 0;
}
