#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "loader.h"
#include "ui_loader.h"
#include "../utils/conf.h"


static void load_button(FILE *, struct panel *panel);
static void process_screen_anchor(struct vec3 *, enum anchor);
static void process_self_anchor(struct vec3 *, struct vec2, enum anchor);


static void process_self_anchor(struct vec3 *p, struct vec2 s, enum anchor a)
{
	//0.01 IS THE WIDTH AND HEIGHT OF THE CUBE OBJ MODEL!
	switch (a) {
	case TOP_LEFT:
		p->x +=  s.x * 0.01;
		p->y -=  s.y * 0.01;
		break;
	case TOP_MIDDLE:
		p->y -= s.y * 0.01;
		break;
	case TOP_RIGHT:
		p->x -=  s.x * 0.01;
		p->y -=  s.y * 0.01;
		break;
	case MIDDLE_LEFT:
		p->x +=  s.x * 0.01;
		break;
	case MIDDLE_MIDDLE:
		//nothing to do!
		break;
	case MIDDLE_RIGHT:
		p->x -=  s.x * 0.01;
		break;
	case BOTTOM_LEFT:
		p->x +=  s.x * 0.01;
		p->y +=  s.y * 0.01;
		break;
	case BOTTOM_MIDDLE:
		p->y +=  s.y * 0.01;
		break;
	case BOTTOM_RIGHT:
		p->x -=  s.x * 0.01;
		p->y +=  s.y * 0.01;
		break;
	}
}


static void process_screen_anchor(struct vec3 *p, enum anchor a)
{
	switch (a) {
	case TOP_LEFT:
		p->x = -1;
		p->y = 1;
		break;
	case TOP_MIDDLE:
		p->x = 0;
		p->y = 1;
		break;
	case TOP_RIGHT:
		p->x = 1;
		p->y = 1;
		break;
	case MIDDLE_LEFT:
		p->x = -1;
		p->y = 0;
		break;
	case MIDDLE_MIDDLE:
		p->x = 0;
		p->y = 0;
		break;
	case MIDDLE_RIGHT:
		p->x = 1;
		p->y = 0;
		break;
	case BOTTOM_LEFT:
		p->x = -1;
		p->y = -1;
		break;
	case BOTTOM_MIDDLE:
		p->x = 0;
		p->y = -1;
		break;
	case BOTTOM_RIGHT:
		p->x = 1;
		p->y = -1;
		break;
	}
}

void load_button(FILE *ui, struct panel *panel)
{
	struct prop_info *prop;
	prop_allocate(&prop);

	//no need for a collision model on a button
	prop->coll_model = NULL;

	struct button *button;
	button_allocate(&button);
	button->prop = prop;

	struct vec3 *tmpcolor = malloc(sizeof(struct vec3)); //this is horrible FIXME

	//must be in a separate string (and in the same order just like printf)
	char params[] = "position=3 anchor=a screen_anchor=a text=s scale=2 value=s color=3";
	conf_get(ui, params,
	&button->position,
	&button->self_anchor,
	&button->screen_anchor,
	button->text,
	&button->scale,
	button->value,
	tmpcolor);


	prop_scale(prop, vec3(button->scale.x, button->scale.y, 1));

	//declare a temporary vec3 that will hold the position computed by the anchors
	struct vec3 apos;
	process_screen_anchor(&apos, button->screen_anchor);
	process_self_anchor(&apos, button->scale, button->screen_anchor);

	//add the temp vec3 to the position, and we have our true position
	button->position = vec3_add(apos, button->position);
	prop_move(prop, button->position);
	
	// = UI_BUTTON in models_index.csv
	char *temp = BUTTON_NAME;
	memcpy(prop->name, temp, sizeof(char) * BUTTON_TEXT_LENGTH);

	//load the model shp texture etc.
	load_components(prop, T_UI);
	prop->model->color = *tmpcolor;
	free(tmpcolor); //aaaahrgh

	//add the button to the panel
	panel->buttons[panel->button_count++] = button;
}

//maybe create a prop struct inside the button and load it like a normal prop?
int ui_loader_load_ui(enum panel_type type, struct panel *panel)
{
	FILE *ui = fopen(UI_FILE, "rb");
	char **markers = ui_get_markers();
	if (conf_goto_marker(ui, markers[type]) == 1) {
		fprintf(stderr, "Error: couldn't find the marker\n");
		return -1;
	}

	enum block_type b_type;
	while ((b_type = conf_get_type(ui)) != T_UNKOWN) {
		switch(b_type) {
		case T_UI_BUTTON:
			printf("this is a button\n");
			load_button(ui, panel);
			break;
		default:
			//not important
			break;
		}
	}

	return 0;
}
