#ifndef TEXTURE_H
#define TEXTURE_H

#include <GL/glew.h>

struct texture_info {
	char *name;
	unsigned int id;
	char *file_path;
	char *type;
	GLuint handle;
};


void texture_allocate(struct texture_info **tex_pointer);
void texture_deallocate(struct texture_info *current_texture);
int texture_search(char *name, struct texture_info *current_texture);
int texture_load(struct texture_info *current_texture);
void texture_bind(struct texture_info *current_texture);
void texture_unbind(void);
void texture_smooth(int);


#endif
