#ifndef SHPROGRAM_H
#define SHPROGRAM_H

#include <GL/glew.h>

struct shp_info {
	char *name;
	char *vert_file_path;
	char *frag_file_path;
	unsigned int id;
	unsigned int used_by;
	GLuint handle;
	unsigned int index;
	GLint uniform_model_matrix;
	GLint uniform_view_matrix;
	GLint uniform_projection_matrix;
	GLint uniform_mvp_matrix;
	GLint uniform_mv_matrix;
	GLint uniform_object_color;
	GLint uniform_offset;
};


void shprogram_initialize(void);
int shprogram_search(char *shp_name, struct shp_info **shp_pointer);
GLuint shprogram_load(struct shp_info *shp);
void shprogram_update_matrices(void);
void shprogram_set_uniforms(/*int shprogram_index*/ struct shp_info *shp);
int shprogram_unload(struct shp_info *current_shp);
int shprogram_allocate(struct shp_info **shp);

#endif
