#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <GL/glew.h>
#include "shader.h"

//This function parses a csv file searching for information relative to the shader name
//that was passed to it. Returns the ID of the shader if it was found, -1 otherwise.
int Shader_load(char *name) //dead function
{
	printf("\nsearching for information on shader %s...\n", name);

	FILE *index = fopen("assets/shaders_index.csv", "rb");
	char file_string[512];

	char shader_name[128] = "none";
	unsigned int id = 0;
	char vertex_shader_path[128] = "none";
	char frag_shader_path[128] = "none";

	while (fgets(file_string, sizeof(file_string), index) != NULL)
	{
		sscanf(file_string, "%[^;];", shader_name);
		if (strcmp(shader_name, name) != 0)
		{
			continue;
		}

		sscanf(file_string, "%[^;];%u;%[^;];%[^\n]", shader_name, &id, vertex_shader_path, frag_shader_path);
		printf("shader_name=%s\nid=%u\nvertex_shader_path=%s\nfrag_shader_path=%s\n\n", shader_name, id, vertex_shader_path, frag_shader_path);
		fclose(index);
		return id;
		

	}
	fclose(index);
	return -1;
}




int shader_gl_load(char *shader_path, GLenum shader_type)
{
	FILE *shader_file;
	long file_size;
	if ((shader_file = fopen(shader_path, "rb")) == NULL)
	{
		fprintf(stderr, "Error: could not open the shader file");
	}
	
	//char file_string[1024]; //a line in the shader should not exceed this number of bytes.

	//! Like they say here (https://stackoverflow.com/a/14002993), one must always check the return
	//values of malloc and fread. So this is a TODO.

	//seek the end of the file
	fseek(shader_file, 0, SEEK_END);

	//declare a long and initialize it with the value of the "file position indicator" that was previously changed with fseek
	file_size = ftell(shader_file);

	rewind(shader_file);

	//declare a char pointer(?) and give it the necessary memory to hold the entire file
	GLchar *shader_code = malloc(sizeof(char) * (file_size + 1));

	//read the file and store its content at the location pointed by the char pointer.
	fread(shader_code, 1, file_size, shader_file);

	//always a good thing to close the file after we're done with it.
	fclose(shader_file);

	//!ADD THE NULL TERMINATOR to the string by adding '\0' to the last case in the array. I tell OpenGL to use the NULL
	//terminator to know the length of the string we pass to the shader (glShaderSource). Don't do this and you
	//go to Funky Town.
	shader_code[file_size] = '\0'; //seems to also work if I simply type "NULL". Is this also correct?

	GLint compile_status;

	GLuint shader = glCreateShader(shader_type);

	//*shader_handle = &shader;

	//give the shader string to the shader
	//oh god is this cast correct
	glShaderSource(shader, 1, (const GLchar * const *)&shader_code, 0); //AMPERSAND IMPORTANT HAMBURGER

	glCompileShader(shader);

	//get the compile status of the shader
	glGetShaderiv(shader, GL_COMPILE_STATUS, &compile_status);
	if (compile_status != GL_TRUE)
	{
		GLint maxLength = 512;
		char errorLog[512];
		fprintf(stderr, "error: failed to compile shader, handle: %d, path: %s\n", shader, shader_path);
		glGetShaderInfoLog(shader, maxLength, &maxLength, errorLog);
		printf("OpenGL log:\n%s\n", errorLog);
		glDeleteShader(shader);
		//return smth here?
	}
	else
	{
		fprintf(stdout, "successfully compiled shader, handle: %d, path: %s\n", shader, shader_path);
	}

	//free the memory allocated for the shader string
	free(shader_code);

	return shader;
}
