#ifndef PROP_H
#define PROP_H

#include "model.h"
#include "texture.h"
#include "shprogram.h"
#include "../utils/vec3.h"
#include "../utils/quat.h"

#define PROP_MAX_NAME_LENGTH 128

enum object_type {
	PROP,
	SKYBOX,
	BBOX,
	PLAYER,
	T_UI,
	T_OPLAYER,
	T_ENTITY,
	T_MAP_PROP,
	T_UNDEFINED
};


struct prop_info {
	int index;	//the prop's index in proplist
	int visible;	//whether or not the prop is rendered
	int exist;	//whether or not the prop is solid and used in calculating collisions
	int map;	//whether or not the prop is/should be written to the map file in edit mode.
	enum object_type type;
	char *name;
	unsigned int *instances;	//the number of times the prop has been loaded
	struct model *model;
	struct model *coll_model;
	struct model *bbox;		//deprecated, old bbox
	struct bbox_info *bbox2;
	struct texture_info *texture;
	struct shp_info *shprogram;
	float *model_matrix;
	float *rotation_matrix;
	struct vec3 color; //not used right now (to change), see color in model struct
	struct vec3 *color_override;
	struct vec3 position;
	struct vec3 velocity;
	struct vec3 scale; //to be soon used
	struct quat rotation; //to be soon used
};


int prop_allocate(struct prop_info **);
int prop_deallocate(struct prop_info *);
void prop_move(struct prop_info *, struct vec3);
void prop_reset_pos(struct prop_info *, struct vec3);
int prop_check_colliding_bboxes(struct prop_info *, struct prop_info **, unsigned int *);
int prop_point_check_colliding_bboxes(struct vec3, struct prop_info **, unsigned int *); //will be obsolete
void prop_scale(struct prop_info *, struct vec3);
void prop_rotate(struct prop_info *, struct quat);
void prop_random_color(struct prop_info *);

#endif
