#ifndef GLEW_H
#define GLEW_H
#include <GL/glew.h>
#endif //does that work? my brain is fried

#ifndef MODEL_H
#define MODEL_H

#include "../utils/vec3.h"
#include "../utils/mat4.h"


#define MODEL_MAX_VERTICES 24000
#define MODEL_MAX_BUFFERS 3
#define MODEL_VERTEX_BUFFER 0
#define MODEL_NORMAL_BUFFER 1
#define MODEL_UV_BUFFER 2

#define OBJ_MAX_LINE_LENGTH 128


struct model {
	float **vertex_data;
	char *name;
	char *vertices_file_path;
	char *vertices_file_type;
	char *shprogram_name;
	char *texture;
	unsigned int *vertex_count;
	GLuint *vbo_handles;
	GLuint vao_handle;
	struct vec3 color;
};

struct bbox_info {
	float *vertices;
	unsigned int vertices_count;
	GLuint vbo_handle;
	GLuint vao_handle;
	struct vec3 color;

	struct vec3 p1;
	struct vec3 p2;
	struct vec3 p3;
	struct vec3 p4;
	struct vec3 p5;
	struct vec3 p6;
	struct vec3 p7;
	struct vec3 p8;
};

/*
 *      +p3-(-x -y +z)---+p4 (+x -y +z)
 *     /|               /|
 *    +p1-(-x -y -z)---+p2 (+y -y -z)
 *    | |              | |
 *    | |              | |
 *    | |              | |
 *    | |              | |
 *    | +p7-(-x +y +z)-|-+p8 (+x +y +z)
 *    |/               |/
 *    +p5-(-x +y -z)---+p6 (+x +y -z)
 *
 *    Actually, only the points 1, 2, 3 and 5 are currently used in the code.
 */





void model_allocate(struct model **model_pointer);
int model_unload(struct model *model);
int model_load_new(char *name, struct model *model_pointer);
void bbox_allocate(struct bbox_info **);
int bbox_get(struct model *, struct bbox_info *);
int bbox_generate(struct bbox_info *, float, float, float);
int bbox_collide(struct bbox_info *, struct bbox_info *, struct vec3);
void bbox_to_world_space(struct bbox_info *, float *); //not used anymore
void bbox_move(struct bbox_info *, struct vec3);
int bbox_point_collide(struct bbox_info *, struct vec3);

#endif
