#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <GL/glew.h>
#include "model.h"
#include "vbo.h"
#include "vao.h"
#include "../utils/csv.h"
#include "../utils/vec2.h"
#include "../utils/io.h"

static int load_obj(char *, float **, unsigned int *);

void model_allocate(struct model **model_pointer)
{
	//allocate the necessary memory for the model and its pointers
	*model_pointer = malloc(sizeof(struct model));

	struct model *current_model = *model_pointer;
	current_model->name = malloc(sizeof(char) * 128);
	current_model->vertices_file_path = malloc(sizeof(char) * 128);
	current_model->vertices_file_type = malloc(sizeof(char) * 128);
	current_model->shprogram_name = malloc(sizeof(char) * 128);
	current_model->vertex_data = malloc(sizeof(float *) * MODEL_MAX_BUFFERS);
	current_model->vertex_count = malloc(sizeof(unsigned int) * MODEL_MAX_BUFFERS);
	//calloc?
	current_model->vertex_count[MODEL_VERTEX_BUFFER] = 0;
	current_model->vertex_count[MODEL_NORMAL_BUFFER] = 0;
	current_model->vertex_count[MODEL_UV_BUFFER] = 0;
	current_model->vbo_handles = malloc(sizeof(GLuint) * MODEL_MAX_BUFFERS);
	current_model->vbo_handles[MODEL_VERTEX_BUFFER] = 0;
	current_model->vbo_handles[MODEL_NORMAL_BUFFER] = 0;
	current_model->vbo_handles[MODEL_UV_BUFFER] = 0;

	// * 4 because a vertice is composed of 4 values, x, y, z, w. * 2.5 because there are two
	//sets of vec4 uploaded (vertices and normals), plus one set of vec2 (texture uv). TODO:
	//make this automated and absolutely clearer.
	/*current_model->vertices = malloc(sizeof(float) * MODEL_MAX_VERTICES * 4 * 2.5);
	current_model->bounding_box_vertices = malloc(sizeof(float) * 32); //32 because 8 * (x y z w)*/
	current_model->texture = malloc(sizeof(char) * 128);
}


void bbox_allocate(struct bbox_info **bbox_pointer)
{

	*bbox_pointer = malloc(sizeof(struct bbox_info));
	struct bbox_info *bbox = *bbox_pointer;

	bbox->vertices = malloc(sizeof(float) * 108);
}







int model_load_new(char *name, struct model *current_model)
{
	printf("\nsearching for information on model %s...\n", name);

	char * csv_string = csv_parse("assets/models_index.csv", "prop_name", name);
	if (csv_string == NULL)
	{
		//if the error message appears 2 times, it's because it's loading the model and coll model
		prnte("Error: could not find the model \"%s\", loading default model\n", name);
		csv_string = csv_parse("assets/models_index.csv", "prop_name", "error");
	}

	sscanf(csv_string, "%[^;];%*u;%[^;];%[^;];%[^;];%f %f %f;%[^\n]",
	current_model->name,
	current_model->vertices_file_path,
	current_model->vertices_file_type,
	current_model->shprogram_name,
	&current_model->color.x,
	&current_model->color.y,
	&current_model->color.z,
	current_model->texture);

	current_model->color = vec3_rgb_clamp(current_model->color);
	//current_model->model_matrix = mat4_identity();

	load_obj(current_model->vertices_file_path, current_model->vertex_data, current_model->vertex_count);

	vbo_create(&current_model->vbo_handles[MODEL_VERTEX_BUFFER]);
	vbo_fill_new(current_model->vbo_handles[MODEL_VERTEX_BUFFER], current_model->vertex_data[MODEL_VERTEX_BUFFER], current_model->vertex_count[MODEL_VERTEX_BUFFER], GL_STATIC_DRAW, VERTICES);

	vbo_create(&current_model->vbo_handles[MODEL_NORMAL_BUFFER]);
	vbo_fill_new(current_model->vbo_handles[MODEL_NORMAL_BUFFER], current_model->vertex_data[MODEL_NORMAL_BUFFER], current_model->vertex_count[MODEL_NORMAL_BUFFER], GL_STATIC_DRAW, NORMALS);

	vbo_create(&current_model->vbo_handles[MODEL_UV_BUFFER]);
	vbo_fill_new(current_model->vbo_handles[MODEL_UV_BUFFER], current_model->vertex_data[MODEL_UV_BUFFER], current_model->vertex_count[MODEL_UV_BUFFER], GL_STATIC_DRAW, UVS);

	return 0;
}



//broken, FIXME
//remove the reference from the model list, and free() all
//memory associated with the passed model pointer
int model_unload(struct model *current_model)
{
	//need to add a function in  l_models. maybe just remove the reference directly in l_models?
	//should probably add a bool to say if the model contains info used by another model.
	free(current_model->name);
	free(current_model->vertices_file_path);
	free(current_model->vertices_file_type);
	free(current_model->shprogram_name);
	//free(current_model->vertices);
	free(current_model->texture);
	free(current_model);
	return 0;

}



// --------------OBJ---------------- //


int load_obj(char *filepath, float **vertex_buffers, unsigned int *vertex_count)
{
	struct face {
		int vert_index;
		int texture_coord_index;
		int norm_index;
	};

	printf("loading the obj file...\n");

	//*3 because a vertex is composed of 3 values.
	vertex_buffers[MODEL_VERTEX_BUFFER] = malloc(sizeof(float) * MODEL_MAX_VERTICES * 3);
	vertex_buffers[MODEL_NORMAL_BUFFER] = malloc(sizeof(float) * MODEL_MAX_VERTICES * 3);
	//same here, but a uv is composed of 2 values.
	vertex_buffers[MODEL_UV_BUFFER] = malloc(sizeof(float) * MODEL_MAX_VERTICES * 2);

	FILE *file;
	if ((file= fopen(filepath, "rb")) == NULL) {
		fprintf(stderr, "Error: the model's obj file could not be found or loaded\n");
		return -1;
	}

	char line[OBJ_MAX_LINE_LENGTH];

	struct vec3 vertex_data[MODEL_MAX_VERTICES];
	struct vec2 texture_uv_data[MODEL_MAX_VERTICES];
	struct vec3 normal_data[MODEL_MAX_VERTICES];
	struct face face_data[MODEL_MAX_VERTICES];

	int vertex_index = 0;
	int texture_uv_index = 0;
	int face_index = 0;
	int normal_index = 0;

	int count = 0;

	while (fgets(line, OBJ_MAX_LINE_LENGTH, file) != NULL) {
		if (count >= MODEL_MAX_VERTICES - 3) {
			fprintf(stderr, "Error: the model contains too many vertices and couldn't be loaded entirely\n");
			free(vertex_buffers[MODEL_VERTEX_BUFFER]);
			free(vertex_buffers[MODEL_NORMAL_BUFFER]);
			free(vertex_buffers[MODEL_UV_BUFFER]);
			vertex_buffers[MODEL_VERTEX_BUFFER] = NULL;
			vertex_buffers[MODEL_NORMAL_BUFFER] = NULL;
			vertex_buffers[MODEL_UV_BUFFER] = NULL;
			return -1;
		}

		if (line[0] == 'v' && line[1] == ' ') {

			struct vec3 vector;
			sscanf(line, "%*s %f %f %f", &vector.x, &vector.y, &vector.z);
			vertex_data[vertex_index++] = vector;

		} else if (line[0] == 'v' && line[1] == 't') {

			struct vec2 coords;
			sscanf(line, "%*s %f %f", &coords.x, &coords.y);
			texture_uv_data[texture_uv_index++] = coords;

		} else if (line[0] == 'v' && line[1] == 'n') {

			struct vec3 vector;
			sscanf(line, "%*s %f %f %f", &vector.x, &vector.y, &vector.z);
			normal_data[normal_index++] = vector;

		} else if (line[0] == 'f' && line[1] == ' ') {

			struct face face1, face2, face3;
			sscanf(line, "%*s %d/%d/%d %d/%d/%d %d/%d/%d",
			&face1.vert_index,
			&face1.texture_coord_index,
			&face1.norm_index,
			&face2.vert_index,
			&face2.texture_coord_index,
			&face2.norm_index,
			&face3.vert_index,
			&face3.texture_coord_index,
			&face3.norm_index);

			face_data[face_index++] = face1;
			face_data[face_index++] = face2;
			face_data[face_index++] = face3;
			count+=3;
		}
		
	}
	printf("float count: %d\n", count);

	//duplicating vertices, because the program doesn't support vertex indexing.
	//is it me or am I loading three times more the amount of normals that I would need? FIXME
	for (int i = 0; i < face_index; i++) {
		struct face current_face = face_data[i];
		//-1 because obj indexing starts at 1, not 0
		struct vec3 point = vertex_data[current_face.vert_index - 1];
		vertex_buffers[MODEL_VERTEX_BUFFER] [vertex_count[MODEL_VERTEX_BUFFER]++] = point.x;
		vertex_buffers[MODEL_VERTEX_BUFFER] [vertex_count[MODEL_VERTEX_BUFFER]++] = point.y;
		vertex_buffers[MODEL_VERTEX_BUFFER] [vertex_count[MODEL_VERTEX_BUFFER]++] = point.z;

		struct vec3 normal = normal_data[current_face.norm_index - 1];
		vertex_buffers[MODEL_NORMAL_BUFFER] [vertex_count[MODEL_NORMAL_BUFFER]++] = normal.x;
		vertex_buffers[MODEL_NORMAL_BUFFER] [vertex_count[MODEL_NORMAL_BUFFER]++] = normal.y;
		vertex_buffers[MODEL_NORMAL_BUFFER] [vertex_count[MODEL_NORMAL_BUFFER]++] = normal.z;

		struct vec2 coords = texture_uv_data[current_face.texture_coord_index - 1];
		vertex_buffers[MODEL_UV_BUFFER] [vertex_count[MODEL_UV_BUFFER]++] = coords.x;
		vertex_buffers[MODEL_UV_BUFFER] [vertex_count[MODEL_UV_BUFFER]++] = coords.y;
	}

	/*for (int i = 0; i < vertex_count[MODEL_VERTEX_BUFFER]; i++) {
		printf("%f\n", vertex_buffers[MODEL_VERTEX_BUFFER][i]);
	}*/

	return 0;
}


int bbox_get(struct model * model, struct bbox_info *bbox)
{
	printf("generating the bounding box...\n");

	float big_x = model->vertex_data[MODEL_VERTEX_BUFFER][0];
	float big_y = model->vertex_data[MODEL_VERTEX_BUFFER][1];
	float big_z = model->vertex_data[MODEL_VERTEX_BUFFER][2];
	float small_x = model->vertex_data[MODEL_VERTEX_BUFFER][0];
	float small_y = model->vertex_data[MODEL_VERTEX_BUFFER][1];
	float small_z = model->vertex_data[MODEL_VERTEX_BUFFER][2];

	for (int i = 0; i < model->vertex_count[MODEL_VERTEX_BUFFER] - 3; i+=3) {
		if (model->vertex_data[MODEL_VERTEX_BUFFER][i] > big_x) {big_x = model->vertex_data[MODEL_VERTEX_BUFFER][i];}
		else if (model->vertex_data[MODEL_VERTEX_BUFFER][i] < small_x) {small_x = model->vertex_data[MODEL_VERTEX_BUFFER][i];}

		if (model->vertex_data[MODEL_VERTEX_BUFFER][i+1] > big_y) {big_y = model->vertex_data[MODEL_VERTEX_BUFFER][i+1];}
		else if (model->vertex_data[MODEL_VERTEX_BUFFER][i+1] < small_y) {small_y = model->vertex_data[MODEL_VERTEX_BUFFER][i+1];}

		if (model->vertex_data[MODEL_VERTEX_BUFFER][i+2] > big_z) {big_z = model->vertex_data[MODEL_VERTEX_BUFFER][i+2];}
		else if (model->vertex_data[MODEL_VERTEX_BUFFER][i+2] < small_z) {small_z = model->vertex_data[MODEL_VERTEX_BUFFER][i+2];}
	}

	/*printf("X=%f Y=%f Z=%f\n", small_x, big_y, small_z);
	printf("X=%f Y=%f Z=%f\n", small_x, big_y, big_z);
	printf("X=%f Y=%f Z=%f\n", small_x, small_y, small_z);
	printf("X=%f Y=%f Z=%f\n", small_x, small_y, big_z);
	printf("X=%f Y=%f Z=%f\n", big_x, big_y, small_z);
	printf("X=%f Y=%f Z=%f\n", big_x, big_y, big_z);
	printf("X=%f Y=%f Z=%f\n", big_x, small_y, small_z);
	printf("X=%f Y=%f Z=%f\n", big_x, small_y, big_z);*/


	bbox->p1.x = small_x; bbox->p1.y = small_y; bbox->p1.z = small_z;
	bbox->p2.x = big_x; bbox->p2.y = small_y; bbox->p2.z = small_z;
	bbox->p3.x = small_x; bbox->p3.y = small_y; bbox->p3.z = big_z;
	bbox->p4.x = big_x; bbox->p4.y = small_y; bbox->p4.z = big_z;
	bbox->p5.x = small_x; bbox->p5.y = big_y; bbox->p5.z = small_z;
	bbox->p6.x = big_x; bbox->p6.y = big_y; bbox->p6.z = small_z;
	bbox->p7.x = small_x; bbox->p7.y = big_y; bbox->p7.z = big_z;
	bbox->p8.x = big_x; bbox->p8.y = big_y; bbox->p8.z = big_z;

	//this creates a little "padding" on the bbox, which prevents the player from getting
	//stuck into walls that are at the edge of the bbox. To document!
	vec3_set_length(&bbox->p1, vec3_length(bbox->p1) + 0.1f);
	vec3_set_length(&bbox->p2, vec3_length(bbox->p2) + 0.1f);
	vec3_set_length(&bbox->p3, vec3_length(bbox->p3) + 0.1f);
	vec3_set_length(&bbox->p4, vec3_length(bbox->p4) + 0.1f);
	vec3_set_length(&bbox->p5, vec3_length(bbox->p5) + 0.1f);
	vec3_set_length(&bbox->p6, vec3_length(bbox->p6) + 0.1f);
	vec3_set_length(&bbox->p7, vec3_length(bbox->p7) + 0.1f);
	vec3_set_length(&bbox->p8, vec3_length(bbox->p8) + 0.1f);


	//oof
	bbox->vertices[0] = small_x;
	bbox->vertices[1] = small_y;
	bbox->vertices[2] = small_z;
	bbox->vertices[3] = small_x;
	bbox->vertices[4] = small_y;
	bbox->vertices[5] = big_z;
	bbox->vertices[6] = small_x;
	bbox->vertices[7] = big_y;
	bbox->vertices[8] = small_z;
	bbox->vertices[9] = small_x;
	bbox->vertices[10] = big_y;
	bbox->vertices[11] = small_z;
	bbox->vertices[12] = small_x;
	bbox->vertices[13] = small_y;
	bbox->vertices[14] = big_z;
	bbox->vertices[15] = small_x;
	bbox->vertices[16] = big_y;
	bbox->vertices[17] = big_z;
	bbox->vertices[18] = big_x;
	bbox->vertices[19] = small_y;
	bbox->vertices[20] = small_z;
	bbox->vertices[21] = big_x;
	bbox->vertices[22] = big_y;
	bbox->vertices[23] = small_z;
	bbox->vertices[24] = big_x;
	bbox->vertices[25] = small_y;
	bbox->vertices[26] = big_z;
	bbox->vertices[27] = big_x;
	bbox->vertices[28] = small_y;
	bbox->vertices[29] = big_z;
	bbox->vertices[30] = big_x;
	bbox->vertices[31] = big_y;
	bbox->vertices[32] = small_z;
	bbox->vertices[33] = big_x;
	bbox->vertices[34] = big_y;
	bbox->vertices[35] = big_z;
	bbox->vertices[36] = small_x;
	bbox->vertices[37] = small_y;
	bbox->vertices[38] = small_z;
	bbox->vertices[39] = big_x;
	bbox->vertices[40] = small_y;
	bbox->vertices[41] = small_z;
	bbox->vertices[42] = small_x;
	bbox->vertices[43] = small_y;
	bbox->vertices[44] = big_z;
	bbox->vertices[45] = small_x;
	bbox->vertices[46] = small_y;
	bbox->vertices[47] = big_z;
	bbox->vertices[48] = big_x;
	bbox->vertices[49] = small_y;
	bbox->vertices[50] = small_z;
	bbox->vertices[51] = big_x;
	bbox->vertices[52] = small_y;
	bbox->vertices[53] = big_z;
	bbox->vertices[54] = small_x;
	bbox->vertices[55] = big_y;
	bbox->vertices[56] = small_z;
	bbox->vertices[57] = small_x;
	bbox->vertices[58] = big_y;
	bbox->vertices[59] = big_z;
	bbox->vertices[60] = big_x;
	bbox->vertices[61] = big_y;
	bbox->vertices[62] = small_z;
	bbox->vertices[63] = big_x;
	bbox->vertices[64] = big_y;
	bbox->vertices[65] = small_z;
	bbox->vertices[66] = small_x;
	bbox->vertices[67] = big_y;
	bbox->vertices[68] = big_z;
	bbox->vertices[69] = big_x;
	bbox->vertices[70] = big_y;
	bbox->vertices[71] = big_z;
	bbox->vertices[72] = small_x;
	bbox->vertices[73] = small_y;
	bbox->vertices[74] = small_z;
	bbox->vertices[75] = small_x;
	bbox->vertices[76] = big_y;
	bbox->vertices[77] = small_z;
	bbox->vertices[78] = big_x;
	bbox->vertices[79] = small_y;
	bbox->vertices[80] = small_z;
	bbox->vertices[81] = big_x;
	bbox->vertices[82] = small_y;
	bbox->vertices[83] = small_z;
	bbox->vertices[84] = small_x;
	bbox->vertices[85] = big_y;
	bbox->vertices[86] = small_z;
	bbox->vertices[87] = big_x;
	bbox->vertices[88] = big_y;
	bbox->vertices[89] = small_z;
	bbox->vertices[90] = small_x;
	bbox->vertices[91] = small_y;
	bbox->vertices[92] = big_z;
	bbox->vertices[93] = big_x;
	bbox->vertices[94] = small_y;
	bbox->vertices[95] = big_z;
	bbox->vertices[96] = small_x;
	bbox->vertices[97] = big_y;
	bbox->vertices[98] = big_z;
	bbox->vertices[99] = small_x;
	bbox->vertices[100] = big_y;
	bbox->vertices[101] = big_z;
	bbox->vertices[102] = big_x;
	bbox->vertices[103] = small_y;
	bbox->vertices[104] = big_z;
	bbox->vertices[105] = big_x;
	bbox->vertices[106] = big_y;
	bbox->vertices[107] = big_z;

	bbox->vertices_count = 108;

	bbox->color.x = 0.0;
	bbox->color.y = 0.0;
	bbox->color.z = 1;
	
	vbo_create(&bbox->vbo_handle);
	vbo_fill_new(bbox->vbo_handle, bbox->vertices, bbox->vertices_count, GL_STATIC_DRAW, VERTICES);

	return 0;
}



int bbox_generate(struct bbox_info *bbox, float width, float height, float depth)
{
	float big_x = width / 2;
	float big_y = height / 2;
	float big_z = depth / 2;
	float small_x = -width / 2;
	float small_y = -height / 2;
	float small_z = -depth / 2;


	bbox->p1.x = small_x; bbox->p1.y = small_y; bbox->p1.z = small_z;
	bbox->p2.x = big_x; bbox->p2.y = small_y; bbox->p2.z = small_z;
	bbox->p3.x = small_x; bbox->p3.y = small_y; bbox->p3.z = big_z;
	bbox->p4.x = big_x; bbox->p4.y = small_y; bbox->p4.z = big_z;
	bbox->p5.x = small_x; bbox->p5.y = big_y; bbox->p5.z = small_z;
	bbox->p6.x = big_x; bbox->p6.y = big_y; bbox->p6.z = small_z;
	bbox->p7.x = small_x; bbox->p7.y = big_y; bbox->p7.z = big_z;
	bbox->p8.x = big_x; bbox->p8.y = big_y; bbox->p8.z = big_z;


	//oof
	bbox->vertices[0] = small_x;
	bbox->vertices[1] = small_y;
	bbox->vertices[2] = small_z;
	bbox->vertices[3] = small_x;
	bbox->vertices[4] = small_y;
	bbox->vertices[5] = big_z;
	bbox->vertices[6] = small_x;
	bbox->vertices[7] = big_y;
	bbox->vertices[8] = small_z;
	bbox->vertices[9] = small_x;
	bbox->vertices[10] = big_y;
	bbox->vertices[11] = small_z;
	bbox->vertices[12] = small_x;
	bbox->vertices[13] = small_y;
	bbox->vertices[14] = big_z;
	bbox->vertices[15] = small_x;
	bbox->vertices[16] = big_y;
	bbox->vertices[17] = big_z;
	bbox->vertices[18] = big_x;
	bbox->vertices[19] = small_y;
	bbox->vertices[20] = small_z;
	bbox->vertices[21] = big_x;
	bbox->vertices[22] = big_y;
	bbox->vertices[23] = small_z;
	bbox->vertices[24] = big_x;
	bbox->vertices[25] = small_y;
	bbox->vertices[26] = big_z;
	bbox->vertices[27] = big_x;
	bbox->vertices[28] = small_y;
	bbox->vertices[29] = big_z;
	bbox->vertices[30] = big_x;
	bbox->vertices[31] = big_y;
	bbox->vertices[32] = small_z;
	bbox->vertices[33] = big_x;
	bbox->vertices[34] = big_y;
	bbox->vertices[35] = big_z;
	bbox->vertices[36] = small_x;
	bbox->vertices[37] = small_y;
	bbox->vertices[38] = small_z;
	bbox->vertices[39] = big_x;
	bbox->vertices[40] = small_y;
	bbox->vertices[41] = small_z;
	bbox->vertices[42] = small_x;
	bbox->vertices[43] = small_y;
	bbox->vertices[44] = big_z;
	bbox->vertices[45] = small_x;
	bbox->vertices[46] = small_y;
	bbox->vertices[47] = big_z;
	bbox->vertices[48] = big_x;
	bbox->vertices[49] = small_y;
	bbox->vertices[50] = small_z;
	bbox->vertices[51] = big_x;
	bbox->vertices[52] = small_y;
	bbox->vertices[53] = big_z;
	bbox->vertices[54] = small_x;
	bbox->vertices[55] = big_y;
	bbox->vertices[56] = small_z;
	bbox->vertices[57] = small_x;
	bbox->vertices[58] = big_y;
	bbox->vertices[59] = big_z;
	bbox->vertices[60] = big_x;
	bbox->vertices[61] = big_y;
	bbox->vertices[62] = small_z;
	bbox->vertices[63] = big_x;
	bbox->vertices[64] = big_y;
	bbox->vertices[65] = small_z;
	bbox->vertices[66] = small_x;
	bbox->vertices[67] = big_y;
	bbox->vertices[68] = big_z;
	bbox->vertices[69] = big_x;
	bbox->vertices[70] = big_y;
	bbox->vertices[71] = big_z;
	bbox->vertices[72] = small_x;
	bbox->vertices[73] = small_y;
	bbox->vertices[74] = small_z;
	bbox->vertices[75] = small_x;
	bbox->vertices[76] = big_y;
	bbox->vertices[77] = small_z;
	bbox->vertices[78] = big_x;
	bbox->vertices[79] = small_y;
	bbox->vertices[80] = small_z;
	bbox->vertices[81] = big_x;
	bbox->vertices[82] = small_y;
	bbox->vertices[83] = small_z;
	bbox->vertices[84] = small_x;
	bbox->vertices[85] = big_y;
	bbox->vertices[86] = small_z;
	bbox->vertices[87] = big_x;
	bbox->vertices[88] = big_y;
	bbox->vertices[89] = small_z;
	bbox->vertices[90] = small_x;
	bbox->vertices[91] = small_y;
	bbox->vertices[92] = big_z;
	bbox->vertices[93] = big_x;
	bbox->vertices[94] = small_y;
	bbox->vertices[95] = big_z;
	bbox->vertices[96] = small_x;
	bbox->vertices[97] = big_y;
	bbox->vertices[98] = big_z;
	bbox->vertices[99] = small_x;
	bbox->vertices[100] = big_y;
	bbox->vertices[101] = big_z;
	bbox->vertices[102] = big_x;
	bbox->vertices[103] = small_y;
	bbox->vertices[104] = big_z;
	bbox->vertices[105] = big_x;
	bbox->vertices[106] = big_y;
	bbox->vertices[107] = big_z;


	bbox->vertices_count = 108;

	bbox->color.x = 0.0;
	bbox->color.y = 0.0;
	bbox->color.z = 1;
	
	vbo_create(&bbox->vbo_handle);
	vbo_fill_new(bbox->vbo_handle, bbox->vertices, bbox->vertices_count, GL_STATIC_DRAW, VERTICES);

	return 0;

}


void bbox_to_world_space(struct bbox_info *bbox, float *matrix)
{
	mat4_multiply_vec3(&bbox->p1, matrix);
	mat4_multiply_vec3(&bbox->p2, matrix);
	mat4_multiply_vec3(&bbox->p3, matrix);
	mat4_multiply_vec3(&bbox->p4, matrix);
	mat4_multiply_vec3(&bbox->p5, matrix);
	mat4_multiply_vec3(&bbox->p6, matrix);
	mat4_multiply_vec3(&bbox->p7, matrix);
	mat4_multiply_vec3(&bbox->p8, matrix);
}


int bbox_collide(struct bbox_info *box1, struct bbox_info *box2, struct vec3 vel)
{
	if (box1->p2.x + vel.x >= box2->p1.x &&
	box1->p1.x + vel.x <= box2->p2.x &&
	box1->p5.y + vel.y >= box2->p1.y &&
	box1->p1.y + vel.y <= box2->p5.y &&
	box1->p3.z + vel.z >= box2->p1.z &&
	box1->p1.z + vel.z <= box2->p3.z)
		return 1;
	return 0;
}

void bbox_move(struct bbox_info *bbox, struct vec3 velocity)
{
	bbox->p1 = vec3_add(bbox->p1, velocity);
	bbox->p2 = vec3_add(bbox->p2, velocity);
	bbox->p3 = vec3_add(bbox->p3, velocity);
	bbox->p4 = vec3_add(bbox->p4, velocity);
	bbox->p5 = vec3_add(bbox->p5, velocity);
	bbox->p6 = vec3_add(bbox->p6, velocity);
	bbox->p7 = vec3_add(bbox->p7, velocity);
	bbox->p8 = vec3_add(bbox->p8, velocity);
}

int bbox_point_collide(struct bbox_info *bbox, struct vec3 v)
{
	if (v.x >= bbox->p1.x && v.x <= bbox->p2.x &&
	v.y >= bbox->p1.y && v.y <= bbox->p5.y &&
	v.z >= bbox->p1.z && v.z <= bbox->p3.z)
		return 1;
	return 0;
}
