#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "map.h"
#include "../utils/csv.h"
#include "../utils/vec3.h"
#include "loader.h"


static int prop_load(void);
static void skybox_load(void);
static void mesh_load(void);
static void player_load(void);

FILE *map_file;

int map_load(char *map_name)
{
	char *csv_string = csv_parse("assets/maps_index.csv", "name", map_name);
	if (csv_string == NULL) {
		fprintf(stderr, "Error: could not find info on the map %s\n", map_name);
		return -1;
	}

	char *file_path = malloc(MAP_MAX_FILE_PATH_LENGTH);
	sscanf(csv_string, "%*[^;];%*d;%[^\n]\n", file_path);

	if ((map_file = fopen(file_path, "rb")) == NULL) {
		fprintf(stderr, "Error: could not find the filepath %s of the map\n", file_path);
		return -1;
	}

	char *string = malloc(sizeof(char) * 50);
	char *type = malloc(sizeof(char) * 8);

	while (fgets(string, sizeof(string), map_file) != NULL) {
		sscanf(string, "%s {\n", type);
		if (strcmp(type, "prop") == 0) {
			prop_load();
		} else if (strcmp(type, "skybox") == 0) {
			 //a few things:
			 //a map MUST have a skybox
			 //a skybox MUST have a texture
			skybox_load();
		} else if (strcmp(type, "mesh") == 0) {
			mesh_load();
		} else if (strcmp(type, "player") == 0) {
			player_load();
		}
	}
	free(string);
	fclose(map_file);
	return 0;
}

//parse the prop to get the necessary info and ask to load the model
int prop_load(void)
{
	char string[128];
	//char prop_name[128] = {ASSET_DEFAULT, '\0'};
	char *prop_name = malloc(sizeof(char) * 128);
	prop_name[0] = ASSET_DEFAULT;
	prop_name[1] = '\0';
	struct vec3 position;

	char key[128];
	char value[128];

	fgets(string, sizeof(string), map_file);
	while (string[0] != '}') {
		sscanf(string, "%[^=]=%[^\n]\n", key, value);

		if (strcmp(key, "name") == 0) {
			memcpy(prop_name, value, sizeof(char) * 128);
		} else if (strcmp(key, "loc") == 0) {
			sscanf(value, "%f %f %f", &position.x, &position.y, &position.z);
		}

		fgets(string, sizeof(string), map_file);
	}
	if (prop_name[0] == ASSET_DEFAULT) {
		fprintf(stderr, "Error: the model doesn't have a name, loading default model\n");
		//loader_load_asset(ASSET_ERROR, position);
	}

	loader_load_asset_new(prop_name, position, PROP);
	return 0;
}

void skybox_load(void)
{
	char string[128];
	char key[128];
	//char value[128];
	char *value = malloc(sizeof(char) * 128);

	fgets(string, sizeof(string), map_file);
	while (string[0] != '}') {
		sscanf(string, "%[^=]=%[^\n]\n", key, value);
		if (strcmp(key, "name") == 0) {
			//loader_load_skybox(value);
			loader_load_asset_new(value, vec3_zero(), SKYBOX);
		}
		fgets(string, sizeof(string), map_file);
	}
}

void mesh_load(void)
{
	char string[30];
	float x, y, z;

	fgets(string, sizeof(string), map_file);
	while (string[0] != '}') {
		sscanf(string, "%f %f %f", &x, &y, &z);
		printf("X=%f, Y=%f, Z=%f\n", x, y, z);
		fgets(string, sizeof(string), map_file);
	}
}

void player_load(void)
{
	char string[30];
	struct vec3 position;
	fgets(string, sizeof(string), map_file); //cause of the "{", TODO
	fgets(string, sizeof(string), map_file);
	sscanf(string, "loc=%f %f %f\n", &position.x, &position.y, &position.z);
	printf("X=%f Y=%f Z=%f\n", position.x, position.y, position.z);
	loader_load_asset_new("ENT_PLAYER" , position, PLAYER);
}
