#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "proplist.h"


static struct prop_info **props_index;
static struct prop_info **close_props_index;
static struct prop_info *skybox;
static struct prop_info *player;
static unsigned int prop_count;

int proplist_initialize(void)
{
	if ((props_index = calloc(MAX_PROPS, sizeof(struct prop_info *))) == NULL) {
		fprintf(stderr, "Error: could not allocate memory for the props index\n");
		return -1;
	}
	if ((close_props_index = calloc(MAX_CLOSE_PROPS, sizeof(struct prop_info *))) == NULL) {
		fprintf(stderr, "Error: could not allocate memory for the close props index\n");
		return -1;
	}

	prop_count = 0;
	return 0;
}

int proplist_add(struct prop_info *prop) //now that I have a prop_count variable, there might be some optimisation to do here.
{
	for (int i = 0; i < MAX_PROPS; i++) {
		if (props_index[i] != 0)
			continue;
		props_index[i] = prop;
		prop_count++;
		return i;
	}
	fprintf(stderr, "Error: the props index is full\n");
	return -1;
}

struct prop_info ** proplist_get_pointer(void)
{
	return props_index;
}


void proplist_set_skybox(struct prop_info *prop)
{
	skybox = prop;
}

struct prop_info * proplist_get_skybox(void)
{
	return skybox;
}

void proplist_set_player(struct prop_info *prop)
{
	player = prop;
}

struct prop_info * proplist_get_player(void)
{
	return player;
}

struct prop_info * proplist_get_prop(char *name)
{
	for (int i = 0; i < MAX_PROPS; i++) {
		if (props_index[i] == 0)
			continue;
		if (strcmp(props_index[i]->name, name) == 0) {
			printf("prop %s is already here!\n", name);
			return props_index[i];
		}
	}
	return NULL;
}

struct prop_info * proplist_get_by_index(int index)
{
	if (props_index[index] != 0 && props_index[index] != NULL)
		return props_index[index];
	return NULL;
}

struct shp_info * proplist_get_shp(char *name)
{
	for (int i = 0; i < MAX_PROPS; i++) {
		if (props_index[i] == 0)
			continue;
		if (strcmp(props_index[i]->shprogram->name, name) == 0) {
			printf("prop %s is already here!\n", name);
			return props_index[i]->shprogram;
		}
	}
	return NULL;
}


unsigned int proplist_get_props_count(void)
{
	return prop_count;
}

//reinitialize the value at the passed index.
void proplist_remove(int i)
{
	props_index[i] = NULL;
}
