#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "l_textures.h"

struct texture_info **textures_index;

int l_textures_initialize(void)
{
	if ((textures_index = calloc(MAX_TEXTURES, sizeof(struct texture_info *))) == NULL) {
		fprintf(stderr, "Error: could not allocate memory for the textures index\n");
		return -1;
	}
	return 0;
}

int l_textures_add(struct texture_info *texture)
{
	for (int i = 0; i < MAX_TEXTURES; i++) {
		if (textures_index[i] != 0)
			continue;
		textures_index[i] = texture;
		return i;
	}
	return -1;
}

int l_textures_get_index(char *text_name)
{
	for (int i = 0; i < MAX_TEXTURES; i++) {
		if (textures_index[i] != 0 && strcmp(textures_index[i]->name, text_name) == 0)
			return i;
	}
	return -1;
}

struct texture_info *** l_textures_get_pointer(void)
{
	return &textures_index;
}
