#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "l_shprograms.h"

//the index that will reference every pointer to shp_info structs
static struct shp_info **shp_index;

//allocate some memory to the array.
int l_shprograms_initialize(void)
{
	if ((shp_index = calloc(MAX_SHPROGRAMS, sizeof(struct shp_info *))) == NULL)
	{
		fprintf(stderr, "Error: could not allocate memory for the shader program list\n");
		return -1;
	}
	return 0;
}

//add the passed pointer to struct shp_info to the array. returns its position
//in the array if successfully added, otherwise -1.
int l_shprograms_add(struct shp_info *shp_info_ptr)
{
	for (int i = 0; i < MAX_SHPROGRAMS; i++)
	{
		if (shp_index[i] != 0)
		{
			printf("index %d already taken.\n", i);
			continue;
		}
		shp_index[i] = shp_info_ptr;
		return i;
	}
	return -1;
}

//returns the position in the array of the shader program identified by the passed id. returns
//-1 if it's not present in the array.
int l_shprogram_get_index(char *shp_name)
{
	for (int i = 0; i < MAX_SHPROGRAMS; i++)
	{
		if (shp_index[i] != 0 && strcmp(shp_index[i]->name, shp_name) == 0)
		{
			printf("%s is already present in the index, recycling\n", shp_index[i]->name);
			return i;
		}
	}
	return -1;
}


struct shp_info *** l_shprogram_get_pointer(void)
{
	return &shp_index;
}


struct shp_info * l_shprogram_get_shprogram(int index)
{
	return shp_index[index];
}
