#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "l_models.h"

//the index that will reference every pointers to model structs
struct model **m_index;
//the skybox (if any)
struct model *skybox;

int l_models_initialise()
{
	//calloc initalises all the memory with 0s
	if ((m_index = calloc(MAX_MODELS, sizeof(struct model *))) == NULL) //i added a * here, because we want to create an array of pointers to structures, not an array of structures, right?
	{
		fprintf(stderr, "Error: could not allocate memory for the models list\n");
		return 1;
	}
	if ((skybox = calloc(1, sizeof(struct model))) == NULL) {
		fprintf(stderr, "Error: could not allocate memory of the skybox\n");
		return 1;
	}
	return 0;
}
/*
//Add the pointer to a model struct to the first place available (designed by 0).
//This function returns the index of the model if it has been added to the list, and -1 if there is
//no room to add the model.
int l_models_add(struct model *model_ptr)
{
	int i = 0;
	while(i < MAX_MODELS)
	{
		//if the case isn't equal to 0, it means a pointer is already there
		if (m_index[i] != 0)
		{
			i++;
			continue;
		}
		m_index[i] = model_ptr;
		//printf("added %s to the models list\n", m_index[i]->name);
		break;
	}
	//if i equals to the maximum number of models allowed, it means it went through
	//all the cases of the array and found no free space.
	if (i == MAX_MODELS)
	{
		fprintf(stderr, "Error: the models list is full");
		return -1;
	}
	model_ptr->index = i;
	return 0;
}



int l_models_get_index(char *name)
{
	for (int i = 0; i < MAX_MODELS; i++) {
		if (m_index[i] != 0 && strcmp(m_index[i]->name, name) == 0)
			return i;
	}
	return -1;
}

void l_models_set_skybox(struct model *skybox_ptr)
{
	skybox = skybox_ptr;
}

struct model * l_models_get_skybox(void)
{
	return skybox;
}

struct model * l_models_get_model(int index)
{
	return m_index[index];
}

struct model *** l_models_get_pointer(void)
{
	return &m_index;
}
*/
