#include "ray.h"

//https://www.lighthouse3d.com/tutorials/maths/ray-triangle-intersection/
//checks is a point + velocity will at some point intersect a given triangle.
//t = the amount of velocity needed to get to the intersection
int ray_triangle_collision(struct vec3 p, struct vec3 vel, struct vec3 v0, struct vec3 v1, struct vec3 v2, struct vec3 *final, float *t)
{
	struct vec3 e1, e2, h, s, q;
	float a, f, u, v;

	e1 = vec3_subtract(v1, v0);
	e2 = vec3_subtract(v2, v0);

	h = vec3_cross(vel, e2);
	a = vec3_dot(e1, h);

	if (a > -0.00001 && a < 0.00001)
		return 0;

	f = 1/a;
	s = vec3_subtract(p, v0);
	u = f * (vec3_dot(s, h));

	if (u < 0.0 || u > 1.0)
		return 0;

	q = vec3_cross(s, e1);
	v = f * vec3_dot(vel, q);

	if (v < 0.0 || u + v > 1.0)
		return 0;

	//at this stage we can compute t to find out where
	//the intersection point is on the line
	*t = f * vec3_dot(e2, q);

	if (*t > 0.00001 && *t <= 1) {//an intersection happened within p and p+vel
		final->x = p.x + vel.x * *t;
		final->y = p.y + vel.y * *t;
		final->z = p.z + vel.z * *t;
		return 1;
	}

	else //this means that there is a line intersection
		 //but not a ray intersection
		 return 0;
}
