#ifndef PLAYER_H
#define PLAYER_H

#include "../utils/vec3.h"


int player_initialize(void);
void player_move_left(void);
void player_move_right(void);
void player_move_forward(void);
void player_move_backward(void);
void player_move_up(void);
void player_move_down(void);
struct vec3 player_get_position(void);
void player_set_position(struct vec3);
void player_update_position(void);
void player_jump_stop(void);
void player_crouch_stop(void);
void player_toggle_noclip(void);
void player_toggle_collisions(void);
float player_get_current_gravity(void);
void player_push(struct vec3);

int player_get_hp(void);
void player_damage(int);


#endif
