#include <stdio.h>
#include <string.h>
#include "../lists/l_models.h"
#include "../lists/l_shprograms.h"
#include "../lists/l_textures.h"
#include "../renderer/renderer.h"
//#include "../loader/map.h"
#include "camera.h"
#include "op.h"
#include "player.h"
#include "../lists/proplist.h"
#include "../ui/ui.h"
#include "../net/clt.h"
#include "../net/oplayers.h"
#include "../utils/states.h"
#include "../utils/num.h"
#include "../ent/proj.h"
#include "../map/edit.h"
#include "../map/map2.h"
#include "cmd.h"
#include "../ui/text.h"
#include "../utils/io.h"

void Op_testmethod(void)
{
	printf("Op_testmethod.\n\n");
	prnt("This is a test %f\n", 3.334f);

	rand_init();

	camera_initialize();
	shprogram_initialize();


	if (l_models_initialise() != 0)
	{
		fprintf(stderr, "Error: failed to initalize the models list\n");
	}
	if (l_shprograms_initialize() != 0)
	{
		fprintf(stderr, "Error: failed to initialize the sh_programs list\n");
	}
	if (l_textures_initialize() < 0)
		fprintf(stderr, "Error: failed to initialize the textures index\n");
	if (proplist_initialize() < 0)
		fprintf(stderr, "Error: failed to initialize the props list\n");

	

	player_initialize();
	text_initialize();
	ui_initialize();
	proj_initialize();
	cmd_initialize();
	renderer_initialize(); //must be last


	//map_load("MAP_SCENE1");
	//map_load("MAP_TEST");
	//map_load("MAP_BBOX");
	//map_load("MAP_REL");
	map2_load("MAP_REL");
	//map2_load("MAP_HARBOR");
	//map_load("MAP_HARBOR");
	//map_load("MAP_ARENA");
	//map_load("MAP_WELC");


}


void op_process_var(int argc, char **argv)
{
	//weak function to parse arguments
	for (int i = 0; i < argc; i++) {

		if (strcmp(argv[i], "-c") == 0 && !extern_is_server) {
			extern_is_client = 1;
			clt_initialise();
			oplayers_init();
			clt_connect(argv[i + 1], argv[i + 2]);
			char a[10];
			sprintf(a, "player %d", clt_get_pid());
			clt_set_name(a); //so this option should be set before -n
		}
		if (strcmp(argv[i], "-e") == 0) {
			extern_is_editing = 1;
			medit_initialize();
		}
		if (strcmp(argv[i], "-n") == 0) {
			clt_set_name(argv[i+1]);
		}
	}
}

void op_version(void)
{
	prnti("progle version %d\n", 3);
}
