#include <stdio.h>
#include <GL/glew.h> //I need this or else glew spits out 1km of errors
#include <GL/freeglut.h>

#include "mouse.h"
#include "../utils/vec3.h"
#include "../ent/proj.h"
#include "camera.h"
#include "player.h"
#include "../utils/states.h"
#include "../map/edit.h"

//GLUT_DOWN = 0, GLUT_UP = 1, surprisingly
int btn_states[8] = {1};
int last_click = 0;

static void btn_down(int, int, int);
static void btn_up(int, int, int);

void mouse_update(int btn, int state, int x, int y)
{
	btn_states[btn] = state;

	if (state == GLUT_DOWN) {
		btn_down(btn, x, y);
	} else if (state == GLUT_UP) {
		btn_up(btn, x, y);
	}
}


static void btn_down(int btn, int x, int y)
{
	switch (btn) {
	case GLUT_LEFT_BUTTON:
		if (extern_is_editing)
			medit_select(x, y);
		else if (extern_current_time - last_click >= 500) {
			proj_load(vec3_add(player_get_position(), vec3(0,2,0)), camera_get_front(), 1.2, -1, P_ROCKET);
			last_click = extern_current_time;
		}
		break;
	}
}

static void btn_up(int btn, int x, int y)
{
	switch (btn) {
	case GLUT_LEFT_BUTTON:
		if (extern_is_editing)
			medit_clear_controls();
		break;
	}
}

void mouse_process(void)
{
	if (!btn_states[GLUT_LEFT_BUTTON])
		if (extern_is_editing) { medit_drag(); } //coordinates are from the camera's viewpoint for now
}
