#include <stdio.h>
#include <stdlib.h>

#include "keyboard.h"
#include "../loader/shprogram.h"
#include "../main.h"
#include "player.h"
#include "../utils/states.h"
#include "../map/map2.h"
#include "cmd.h"
#include "../ui/text.h"
#include "../utils/io.h"

static int key_states[256] = {0};
static char command[128] = {0};//string entered by the user
static int command_index = 0;
static int cmd_string = -1;


void keyboard_up(unsigned char key, int x, int y)
{
	key_states[key] = 0;

	switch (key) {
	case ' ':
		player_jump_stop();
		break;
	case 'c':
		player_crouch_stop();
		break;
	}
}

void keyboard_down(unsigned char key, int x, int y)
{
	if (extern_is_typing) {
		switch (key) {
		case 8: //backspace
			if (command_index > 0) {
				command_index--;
				text_remove_chars(cmd_string, 1);
			}
			break;
		case '\r': //carriage return (enter)
			command[command_index] = '\0';
			prntm(command);
			//fall through
		case 27: //escape
			extern_is_typing = 0;
			command_index = 0;
			text_empty(cmd_string);
			states_key_repeat(0);
			return;
		default:
			command[command_index++] = key;
			text_append_char(cmd_string, key);
		}

	} else if (extern_is_cmd) {
		switch (key) {
		case 8: //backspace
			if (command_index > 0) {
				command_index--;
				text_remove_chars(cmd_string, 1);
			}
			break;
		case '\r': //carriage return (enter)
			command[command_index++] = '\n';
			command[command_index] = '\0';
			cmd_exec(command);

			//fall through
		case 27: //escape
			extern_is_cmd = 0;
			command_index = 0;
			text_empty(cmd_string);
			states_key_repeat(0);
			return;
		default:
			if (command_index < CMD_MAX_LENGTH) {
				command[command_index++] = key;
				text_append_char(cmd_string, key);
			}
		}

	} else {
		key_states[key] = 1;

		switch(key) {
		case 'n':
			player_toggle_noclip();
			break;
		case 'l':
			player_toggle_collisions();
			break;
		case ':':
			states_key_repeat(1);
			extern_is_cmd = 1;
			text_append_char(cmd_string, key);
			break;
		case 't':
			states_key_repeat(1);
			extern_is_typing = 1;
			text_append_char(cmd_string, '>');
		}
	}
}

void keyboard_special(int key, int x, int y)
{
	switch (key)
	{
		case GLUT_KEY_LEFT:
			break;
		case GLUT_KEY_RIGHT:
			break;
	}
}

void keyboard_process(void)
{
	if (key_states['w'])
		player_move_forward();
	if (key_states['a'])
		player_move_left();
	if (key_states['s'])
		player_move_backward();
	if (key_states['d'])
		player_move_right();
	if (key_states[' '])
		player_move_up();
	if (key_states['c'])
		player_move_down();
	if (key_states[27])
		exit(EXIT_SUCCESS);

	//make a check if keys were pressed to avoid calling
	//that constantly?
	shprogram_update_matrices();
	
}

//changes which string the keyboard will output the typed characters in.
void keyboard_set_output(int string)
{
	cmd_string = string;
}
