#ifndef COLLISION_H
#define COLLISION_H

#include "../utils/vec3.h"
#include "../loader/prop.h"

struct triangle {
	struct vec3 a;
	struct vec3 b;
	struct vec3 c;
	struct vec3 n;
};

struct plane {
	struct vec3 o;
	struct vec3 n;
};

struct collision_info {
	int found_collision;
	struct vec3 position;
	struct vec3 velocity;
	struct vec3 collision_point;
	float collision_distance;
	float t;
	struct triangle tri;
	struct plane plane;
	int airborne;
	struct vec3 e_radius;
	struct prop_info **colliding_props;
	unsigned int colliding_props_count;
};

int collision_check(struct collision_info *, struct vec3 *, struct vec3 *, struct prop_info *);

#endif
