#include <math.h>
#include <stdio.h>
#include "collision.h"
#include "player.h"

#define VERY_CLOSE_DIST 0.02 //was 0.01, then 0.005. too little and you can end up stuck in props

//This is a bad implementation of Kasper Fauerby's Collision detection algorithm. More
//work needs to be done, but I've had enough of this
//https://www.peroxide.dk/papers/collision/collision.pdf


static int check_triangle(struct collision_info *, struct triangle, struct vec3, struct vec3);
static float plane_signed_dist(struct plane, struct vec3);
static int point_in_triangle(struct vec3, struct vec3, struct vec3, struct vec3);
static struct plane plane_from_triangle(struct vec3, struct vec3, struct vec3);
static int get_lowest_root(float, float, float, float, float *);


//extremely flawed, doesn't work with not perfectly round spheres, and I don't know why
int collision_check(struct collision_info *coll_info, struct vec3 *position, struct vec3 *velocity, struct prop_info *prop)
{
	static int rec = 0; //TODO: this is horrible

	float *verts;
	unsigned int count;
	struct vec3 e_radius = vec3(2.5f, 2.5f, 2.5f); //TODO
	struct vec3 pos = vec3_divide(*position, e_radius);
	struct vec3 vel = vec3_divide(*velocity, e_radius);

	coll_info->velocity = *velocity;
	coll_info->position = *position;
	coll_info->found_collision = 0;
	coll_info->collision_distance = 0;
	coll_info->e_radius = e_radius;
	struct triangle tri;
	
	for (int a = 0; a < coll_info->colliding_props_count; a++) {
		struct prop_info *current_prop = coll_info->colliding_props[a];

		if (current_prop->coll_model == NULL)
			continue;

		verts = current_prop->coll_model->vertex_data[MODEL_VERTEX_BUFFER];
		count = current_prop->coll_model->vertex_count[MODEL_VERTEX_BUFFER];

		for (int i = 0; i < count - 9; i+= 9) {
			tri.a = vec3(verts[i], verts[i+1], verts[i+2]);
			tri.b = vec3(verts[i+3], verts[i+4], verts[i+5]);
			tri.c = vec3(verts[i+6], verts[i+7], verts[i+8]);
			tri.n = vec3(verts[i], verts[i+1], verts[i+2]);

			tri.a = vec3_divide(tri.a, e_radius);
			tri.b = vec3_divide(tri.b, e_radius);
			tri.c = vec3_divide(tri.c, e_radius);
			tri.n = vec3_divide(tri.n, e_radius);

			if (check_triangle(coll_info, tri, pos, vel)) {
				//printf("collision\n");
			}
		}
	}

	if (!coll_info->found_collision) {
		*position = vec3_add(*position, *velocity);
	} else {

		struct vec3 new_base_point = *position;
		struct vec3 collision_point = vec3_multiply(coll_info->collision_point, e_radius);


		//in every single code I viewed, this is not "<=" but ">=". But, if I do what they
		//do, the player ends up stucked when it crosses any holes. But now, the player is
		//shaking a little, like the path is bumpy.
		if (coll_info->collision_distance >= VERY_CLOSE_DIST) {

			struct vec3 v = *velocity;
			vec3_set_length(&v, coll_info->collision_distance - VERY_CLOSE_DIST);
			new_base_point = vec3_add(*position, v);

			v = vec3_normalize(v);
			collision_point = vec3_subtract(collision_point, vec3_multiply_float(v, VERY_CLOSE_DIST));

		}

		struct plane slide_plane;
		slide_plane.o = collision_point;
		slide_plane.n = vec3_normalize(vec3_subtract(new_base_point, collision_point));


		//prevents the player of sliding when not on steep ground
		if (fabs(slide_plane.n.y) > 0.7) {
			//nullify the gravity that was applied to the velocity->y vector.
			velocity->y += player_get_current_gravity();
			coll_info->airborne = 0;
		} else {
			coll_info->airborne = 1;
		}



		struct vec3 old_dest = vec3_add(new_base_point, *velocity);
		float signed_dist = plane_signed_dist(slide_plane, old_dest);
		struct vec3 new_dest = vec3_subtract(old_dest, vec3_multiply_float(slide_plane.n, signed_dist));
		struct vec3 new_vel = vec3_subtract(new_dest, collision_point);

		//ramp slide! like source games!
		//if the new up velocity exceeds 0.5, the player will be considered airborne.
		//look at how this new velocity is calculated above.
		if (new_vel.y > 0.4)
			coll_info->airborne = 1;


		*velocity = new_vel;
		//*position = vec3_add(new_base_point, *velocity);
		*position = new_base_point;

		rec++;
		if (vec3_length(*velocity) > 0.0005f && rec < 5) {
			//printf("RECURSION\n");
			coll_info->velocity = *velocity;
			coll_info->position = *position;
			coll_info->found_collision = 0;
			coll_info->collision_distance = 0;
			collision_check(coll_info, position, velocity, prop);
		}
		rec = 0;
		return 1;
	}
	return 0;
}

//From this point, the code here is mostly taken from the exengine engine, as I
//don't know how to make something this complex. The project is avaiable
//here: https://github.com/eg-z/exengine
//The project is under the MIT license, which you can consult in the LICENSE-3RD-PARTY.txt file.

int check_triangle(struct collision_info *coll_info, struct triangle tri, struct vec3 pos, struct vec3 vel)
{
	//vel and pos are in e-space, the same values int the coll_info struct are not.

	struct plane p = plane_from_triangle(tri.a, tri.b, tri.c);
	//don't forget that, or you'll waste another day
	p.n = vec3_normalize(p.n);

	double t0, t1;
	int embed = 0;

	double signed_dist_to_plane = plane_signed_dist(p, pos);

	float n_dot_v = vec3_dot(p.n, vel);
	if (n_dot_v == 0.0f) {
		if (fabs(signed_dist_to_plane) >= 1.0) {
			return 0;
		} else {
			embed = 1;
			t0 = 0.0;
			t1 = 1.0;
		}
	} else {
		t0 = (-1.0f - signed_dist_to_plane) / n_dot_v;
		t1 = (1.0f - signed_dist_to_plane) / n_dot_v;
		if (t0 > t1 ) {
			double temp = t1;
			t1 = t0;
			t0 = temp;
		}
		if (t0 > 1.0 || t1 < 0.0)
			return 0;
		if (t0 < 0.0) t0 = 0.0;
		if (t1 < 0.0) t1 = 0.0;
		if (t0 > 1.0) t0 = 1.0;
		if (t1 > 1.0) t1 = 1.0;
	}
	
	struct vec3 collision_point;
	int found_collision = 0;
	float t = 1.0f;

	if (!embed) {
		//struct vec3 plane_intersection_point = vec3_add(vec3_subtract(pos, p.n), vec3_multiply_float(vel, t0));
		struct vec3 temp, plane_intersection_point;
		plane_intersection_point = vec3_subtract(pos, p.n);
		temp = vec3_multiply_float(vel, t0);
		plane_intersection_point = vec3_add(plane_intersection_point, temp);

		if (point_in_triangle(plane_intersection_point, tri.a, tri.b, tri.c)) {
			found_collision = 1;
			t = t0; //useful?
			collision_point = plane_intersection_point;
		}
	}

	//if no collision with triangle faces, check the points and edges
	
	if (!found_collision) {
		struct vec3 velocity, base, temp;
		velocity = vel;
		base = pos;

		float velocity_sqrt_length = vec3_len2(velocity);
		float a, b, c;
		float new_t;
		a = velocity_sqrt_length;

		//point 1
		temp = vec3_subtract(base, tri.a);
		b = 2.0f * (vec3_dot(velocity, temp));
		temp = vec3_subtract(tri.a, base);
		c = vec3_len2(temp) - 1.0f;
		if (get_lowest_root(a, b, c, t, &new_t) == 1) {
			t = new_t;
			found_collision = 1;
			collision_point = tri.a;
		}

		//point 2
		if (found_collision == 0) {
			temp = vec3_subtract(base, tri.b);
			b = 2.0f * (vec3_dot(velocity, temp));
			temp = vec3_subtract(tri.b, base);
			c = vec3_len2(temp) - 1.0f;
			if (get_lowest_root(a, b, c, t, &new_t) == 1) {
				t = new_t;
				found_collision = 1;
				collision_point = tri.b;
			}
		}

		//point 3
		if (found_collision == 0) {
			temp = vec3_subtract(base, tri.c);
			b = 2.0f * (vec3_dot(velocity, temp));
			temp = vec3_subtract(tri.c, base);
			c = vec3_len2(temp) - 1.0f;
			if (get_lowest_root(a, b, c, t, &new_t) == 1) {
				t = new_t;
				found_collision = 1;
				collision_point = tri.c;
			}
		}

		//check the edges
		//p1 -> p2
		struct vec3 edge, base_to_vertex;
		edge = vec3_subtract(tri.b, tri.a);
		base_to_vertex = vec3_subtract(tri.a, base);
		float edge_sqrt_length = vec3_len2(edge);
		float edge_dot_velocity = vec3_dot(edge, velocity);
		float edge_dot_base_to_vertex = vec3_dot(edge, base_to_vertex);

		a = edge_sqrt_length * -velocity_sqrt_length + edge_dot_velocity * edge_dot_velocity;
		b = edge_sqrt_length * (2.0f * vec3_dot(velocity, base_to_vertex)) - 2.0f * edge_dot_velocity *
			edge_dot_base_to_vertex;
		c = edge_sqrt_length * (1.0f - vec3_len2(base_to_vertex)) + edge_dot_base_to_vertex *
			edge_dot_base_to_vertex;

		//do we collide with an infinite edge?
		if (get_lowest_root(a, b, c, t, &new_t) == 1) {
			float f = (edge_dot_velocity * new_t - edge_dot_base_to_vertex) / edge_sqrt_length;
			if (f >= 0.0f && f <= 1.0f) {
				t = new_t;
				found_collision = 1;
				temp = vec3_multiply_float(edge, f);
				temp = vec3_add(temp, tri.a);
				collision_point = temp;
			}
		}

		//p2 -> p3
		edge = vec3_subtract(tri.c, tri.b);
		base_to_vertex = vec3_subtract(tri.b, base);
		edge_sqrt_length = vec3_len2(edge);
		edge_dot_velocity = vec3_dot(edge, velocity);
		edge_dot_base_to_vertex = vec3_dot(edge, base_to_vertex);

		a = edge_sqrt_length * -velocity_sqrt_length + edge_dot_velocity * edge_dot_velocity;
		b = edge_sqrt_length * (2.0f * vec3_dot(velocity, base_to_vertex)) - 2.0f * edge_dot_velocity *
			edge_dot_base_to_vertex;
		c = edge_sqrt_length * (1.0f - vec3_len2(base_to_vertex)) + edge_dot_base_to_vertex *
			edge_dot_base_to_vertex;

		//do we collide with an infinite edge?
		if (get_lowest_root(a, b, c, t, &new_t) == 1) {
			float f = (edge_dot_velocity * new_t - edge_dot_base_to_vertex) / edge_sqrt_length;
			if (f >= 0.0f && f <= 1.0f) {
				t = new_t;
				found_collision = 1;
				temp = vec3_multiply_float(edge, f);
				temp = vec3_add(temp, tri.b);
				collision_point = temp;
			}
		}

		//p3 -> p1
		edge = vec3_subtract(tri.a, tri.c);
		base_to_vertex = vec3_subtract(tri.c, base);
		edge_sqrt_length = vec3_len2(edge);
		edge_dot_velocity = vec3_dot(edge, velocity);
		edge_dot_base_to_vertex = vec3_dot(edge, base_to_vertex);

		a = edge_sqrt_length * -velocity_sqrt_length + edge_dot_velocity * edge_dot_velocity;
		b = edge_sqrt_length * (2.0f * vec3_dot(velocity, base_to_vertex)) - 2.0f * edge_dot_velocity *
			edge_dot_base_to_vertex;
		c = edge_sqrt_length * (1.0f - vec3_len2(base_to_vertex)) + edge_dot_base_to_vertex *
			edge_dot_base_to_vertex;

		//do we collide with an infinite edge?
		if (get_lowest_root(a, b, c, t, &new_t) == 1) {
			float f = (edge_dot_velocity * new_t - edge_dot_base_to_vertex) / edge_sqrt_length;
			if (f >= 0.0f && f <= 1.0f) {
				t = new_t;
				found_collision = 1;
				temp = vec3_multiply_float(edge, f);
				temp = vec3_add(temp, tri.c);
				collision_point = temp;
			}
		}
	}


	if (found_collision) {
		//since it's used outside of this, it shouldn't be the e-space coords right?
		float dist_to_coll = t * vec3_length(coll_info->velocity);
		//float dist_to_coll = t * vec3_length(vel);
		if (coll_info->found_collision == 0 || dist_to_coll < coll_info->collision_distance) {
			coll_info->collision_distance = dist_to_coll;
			coll_info->collision_point = collision_point;
			coll_info->found_collision = 1;
			coll_info->t = t;
			coll_info->tri = tri;
			coll_info->plane = p;
			return 1;
		}
	}
	return 0;
}

float plane_signed_dist(struct plane p, struct vec3 pos)
{
	return vec3_dot(pos, p.n) - vec3_dot(p.n, p.o);
}

int point_in_triangle(struct vec3 point, struct vec3 p1, struct vec3 p2, struct vec3 p3)
{
	struct vec3 u, v, w, vw, vu, uw, uv;

	u = vec3_subtract(p2, p1);
	v = vec3_subtract(p3, p1);
	w = vec3_subtract(point, p1);

	vw = vec3_cross(v, w);
	vu = vec3_cross(v, u);

	if (vec3_dot(vw, vu) < 0.0f)
		return 0;
	
	uw = vec3_cross(u, w);
	uv = vec3_cross(u, v);

	if (vec3_dot(uw, uv) < 0.0f)
		return 0;

	float d = vec3_length(uv);
	float r = vec3_length(vw) / d;
	float t = vec3_length(uw) / d;

	return ((r + t) <= 1);
}


struct plane plane_from_triangle(struct vec3 a, struct vec3 b, struct vec3 c)
{
	struct vec3 ba, ca;
	ba = vec3_subtract(b, a);
	ca = vec3_subtract(c, a);

	struct vec3 temp = vec3_cross(ba, ca);
	vec3_normalize(temp);

	struct plane p;
	p.o = a;
	p.n = temp;
	return p;
}

static int get_lowest_root(float a, float b, float c, float max, float *root)
{
	float determinant = b * b - 4.0f * a * c;
	if (determinant < 0.0f)
		return 0;
	float sqrtd = sqrtf(determinant);
	float r1 = (-b - sqrtd) / (2.0f * a);
	float r2 = (-b + sqrtd) / (2.0f * a);

	if (r1 > r2) {
		float temp = r2;
		r2 = r1;
		r1 = temp;
	}

	if (r1 > 0 && r1 < max) {
		*root = r1;
		return 1;
	}
	if (r2 > 0 && r2 < max) {
		*root = r2;
		return 1;
	}
	return 0;
}
