/*
 * coll.* is a more lightweight(?)/rewrite of collision.*.
 * The name is shorter, it should be a dead giveaway!
 */

#ifndef COLL_H
#define COLL_H

#include "../utils/vec3.h"
#include "../loader/prop.h"
#include "../lists/proplist.h"

struct coll_info {
	struct vec3 position;
	struct vec3 velocity;
	struct vec3 collision_point;
	struct prop_info *coll_props[MAX_PROPS];
	struct prop_info *colliding_prop;
	unsigned int colliding_prop_index;
	unsigned int coll_props_count;
	float t;
};

int coll_point_collide(struct coll_info *);
int coll_ray_collide_bbox(struct coll_info *ci);



#endif
