#include <stdio.h>

#include "coll.h"
#include "ray.h"
#include "../lists/proplist.h"

static int compare_t(struct coll_info *, struct vec3, float);

//check if a point+velocity intersect any triangles of a given list of props.
int coll_point_collide(struct coll_info *ci)
{
	float *verts;
	int count, coll = 0;
	struct vec3 cp;
	float t;
	struct vec3 p1, p2, p3;

	for (int i = 0; i < ci->coll_props_count; i++) {
		struct prop_info *p = ci->coll_props[i];
		//if (!p->exist) { continue; } //props who haven't the exist flag can sometimes have to be checked
		if (p->coll_model == NULL) { continue; }

		verts = p->coll_model->vertex_data[MODEL_VERTEX_BUFFER];
		count = p->coll_model->vertex_count[MODEL_VERTEX_BUFFER];

		for (int e = 0; e < count-9; e+= 9) {
			p1 = vec3(verts[e], verts[e+1], verts[e+2]);
			p2 = vec3(verts[e+3], verts[e+4], verts[e+5]);
			p3 = vec3(verts[e+6], verts[e+7], verts[e+8]);
			//printf("%s x=%f y=%f z=%f\n",p->name, p1.x, p1.y, p1.z);
			if (ray_triangle_collision(ci->position, ci->velocity, p1, p2, p3, &cp, &t)) {
				coll = 1;
				//bug: sometimes, this code registers a collision but compare_t() still
				//returns 0. first_prop ensures that colliding_prop doesn't stay empty.
				if (compare_t(ci, cp, t)) {
					ci->colliding_prop = p;
					ci->colliding_prop_index = i;
				}
			}
		}
	}
	if (coll) {
		return 1;
	}
	return 0;
}

//get all the clolliding bboxes that the ray inside coll_info goes through and
//put them in coll_info's prop list.
int coll_ray_collide_bbox(struct coll_info *ci)
{
	float *verts;
	int count, coll_count = 0, coll = 0;
	struct vec3 cp;
	float t;
	struct vec3 p1, p2, p3;
	struct prop_info **plist = proplist_get_pointer();

	for (int i = 0; i < MAX_PROPS; i++) {
		struct prop_info *p = plist[i];
		if (p == 0 || !p->exist || p->coll_model == NULL) { continue; }

		verts = p->bbox2->vertices;
		count = p->bbox2->vertices_count;

		//for each triangle in the bbox, check if the ray goes through them
		for (int e = 0; e < count-9; e+=9) {
			p1 = vec3(verts[e], verts[e+1], verts[e+2]);
			p2 = vec3(verts[e+3], verts[e+4], verts[e+5]);
			p3 = vec3(verts[e+6], verts[e+7], verts[e+8]);
			if (ray_triangle_collision(ci->position, ci->velocity, p1, p2, p3, &cp, &t)) {
				coll = 1;
				//DO NOT compare_t()!! if coll_info is reused after this you're gonna get funky results
			}
		}
		if (coll) {
			ci->coll_props[coll_count] = p;
			coll_count++;
			coll = 0;
		}
	}
	if (coll_count) {
		ci->coll_props_count = coll_count;
		return 1;
	}
	return 0;
}

//checks if the given collision is closer than the previous collision stored by ci
//if it is, replace it
static int compare_t(struct coll_info *ci, struct vec3 cp, float t)
{
	if (t < ci->t) {
		ci->t = t;
		ci->collision_point = cp;
		return 1;
	}
	return 0;
}
