#ifndef CAMERA_H
#define CAMERA_H

void camera_initialize(void);
struct mat4 camera_get_mat4(void);
void camera_check_movement(int x, int y);
void camera_rotate(int delta_x, int delta_y);
float * camera_get_projection_matrix_pointer(void);
float * camera_get_view_matrix_pointer(void);
void camera_update_view_matrix(void);
struct vec3 camera_get_front(void);
struct vec3 camera_get_up_axis(void);
void camera_set_position(struct vec3);
struct vec3 camera_get_position(void);
float camera_get_yaw(void);
float camera_get_pitch(void);

#endif
