/*
 * proj.* handle the creation and deletion of projectiles. They update their trajectory and
 * check if they come into contact with other props, and respond accordingly by deleting them
 * or making them explode.
 */

#ifndef PROJ_H
#define PROJ_H

#include "../utils/vec3.h"
#include "../utils/mat4.h"
#include "../loader/loader.h"

#define MAX_PROJECTILES 128

//projectile informations
struct proj {
	int index;
	struct vec3 position;
	struct vec3 velocity;
	float speed;			//only useful when playing online
	int damage;
	int exist;			//whether the projectile interacts with the world or not
	float knockback;		//the force applied to people around it
	float explosion_radius;
	struct prop_info *prop;		//the prop used as the projectile's model
	float *model_matrix;		//this matrix overrides the prop's matrix
	int ttl;			//time to live, in milliseconds
	int birth;			//time the projectile was created
	int owner;			//the pid of the projectile's owner
};

//types of projectiles available
enum P_TYPE {
	P_ROCKET,
	P_OROCKET, 	//online rocket, coming from other players
	P_EXPLOSION
};

int proj_initialize(void);
int proj_load(struct vec3, struct vec3, float, int, enum P_TYPE);
int proj_unload(struct proj *);
void proj_update(struct proj *);
void proj_update_all(void);
struct proj ** proj_get_ptr(void);



#endif
