#version 330

layout(location = 0) in vec3 position;
layout(location = 2) in vec2 uv;


uniform mat4 model_matrix;
uniform mat4 view_matrix;
uniform mat4 projection_matrix;

uniform vec3 offset;


out vec4 gl_Position;
out vec2 frag_uv;

void main()
{
	vec4 pos = model_matrix * vec4(position, 1) + vec4(offset, 0);
	pos.z = 0;
	gl_Position = pos;
	frag_uv = uv;
}
