#version 330

layout(location = 0) in vec4 position;
layout(location = 2) in vec2 uv;

uniform mat4 model_matrix;
uniform mat4 view_matrix;
uniform mat4 projection_matrix;

out vec4 gl_Position;
out vec4 frag_position;
out vec2 frag_uv;

void main()
{
	frag_position = model_matrix * position;
	frag_uv = uv;

	vec4 pos = projection_matrix * view_matrix * model_matrix * position;
	gl_Position = pos.xyww;
}
